package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialAssetsTransferBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialAssetsTransferBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 资产调拨转移申请单明细前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class FinancialAssetsTransferBillDetailController {

  @Autowired
  private IFinancialAssetsTransferBillDetailService financialAssetsTransferBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialAssetsTransferBillDetail 资产调拨转移申请单明细
   * @return
   */
  @GetMapping("/financialassetstransferbilldetails" )
  public XfR getFinancialAssetsTransferBillDetails(XfPage page, FinancialAssetsTransferBillDetail financialAssetsTransferBillDetail) {
    return XfR.ok(financialAssetsTransferBillDetailServiceImpl.page(page, Wrappers.query(financialAssetsTransferBillDetail)));
  }

  /**
   * 通过id查询资产调拨转移申请单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialassetstransferbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialAssetsTransferBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增资产调拨转移申请单明细
   * @param financialAssetsTransferBillDetail 资产调拨转移申请单明细
   * @return XfR
   */
  @PostMapping("/financialassetstransferbilldetails")
  public XfR save(@RequestBody FinancialAssetsTransferBillDetail financialAssetsTransferBillDetail) {
     return XfR.ok(financialAssetsTransferBillDetailServiceImpl.save(financialAssetsTransferBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据资产调拨转移申请单明细
   * @param financialAssetsTransferBillDetail 资产调拨转移申请单明细
   * @return XfR
   */
  @PutMapping("/financialassetstransferbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialAssetsTransferBillDetail financialAssetsTransferBillDetail,@PathVariable Long id) {
      financialAssetsTransferBillDetail.setId(id);
      return XfR.ok(financialAssetsTransferBillDetailServiceImpl.updateById(financialAssetsTransferBillDetail));
  }

  /**
   * 修改-传入修改的数据资产调拨转移申请单明细
   * @param financialAssetsTransferBillDetail 资产调拨转移申请单明细
   * @return XfR
   */
  @PatchMapping("/financialassetstransferbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialAssetsTransferBillDetail financialAssetsTransferBillDetail,@PathVariable Long id) {
      FinancialAssetsTransferBillDetail upfinancialAssetsTransferBillDetail = financialAssetsTransferBillDetailServiceImpl.getById(id);
      if(upfinancialAssetsTransferBillDetail != null){
        upfinancialAssetsTransferBillDetail = ObjectCopyUtils.copyProperties(financialAssetsTransferBillDetail,upfinancialAssetsTransferBillDetail,true);
      }
      return XfR.ok(financialAssetsTransferBillDetailServiceImpl.updateById(upfinancialAssetsTransferBillDetail));
  }

  /**
   * 通过id删除资产调拨转移申请单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialassetstransferbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialAssetsTransferBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialassetstransferbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_assets_transfer_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialAssetsTransferBillDetailServiceImpl.querys(params));
  }

}
