package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialPurchaseContractBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialPurchaseContractBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class FinancialPurchaseContractBillController {

  @Autowired
  private IFinancialPurchaseContractBillService financialPurchaseContractBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPurchaseContractBill ${table.comment}
   * @return
   */
  @GetMapping("/financialpurchasecontractbills" )
  public XfR getFinancialPurchaseContractBills(XfPage page, FinancialPurchaseContractBill financialPurchaseContractBill) {
    return XfR.ok(financialPurchaseContractBillServiceImpl.page(page, Wrappers.query(financialPurchaseContractBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpurchasecontractbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseContractBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialPurchaseContractBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialpurchasecontractbills")
  public XfR save(@RequestBody FinancialPurchaseContractBill financialPurchaseContractBill) {
     return XfR.ok(financialPurchaseContractBillServiceImpl.save(financialPurchaseContractBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialPurchaseContractBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialpurchasecontractbills/{id}")
  public XfR putUpdate(@RequestBody FinancialPurchaseContractBill financialPurchaseContractBill,@PathVariable Long id) {
      financialPurchaseContractBill.setId(id);
      return XfR.ok(financialPurchaseContractBillServiceImpl.updateById(financialPurchaseContractBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialPurchaseContractBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialpurchasecontractbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialPurchaseContractBill financialPurchaseContractBill,@PathVariable Long id) {
      FinancialPurchaseContractBill upfinancialPurchaseContractBill = financialPurchaseContractBillServiceImpl.getById(id);
      if(upfinancialPurchaseContractBill != null){
        upfinancialPurchaseContractBill = ObjectCopyUtils.copyProperties(financialPurchaseContractBill,upfinancialPurchaseContractBill,true);
      }
      return XfR.ok(financialPurchaseContractBillServiceImpl.updateById(upfinancialPurchaseContractBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpurchasecontractbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseContractBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialpurchasecontractbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_purchase_contract_bill");
     params.put("request", condition);

     return XfR.ok(financialPurchaseContractBillServiceImpl.querys(params));
  }

}
