package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.MemberCost;
import com.xforceplus.ultraman.app.financialsettlement.service.IMemberCostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class MemberCostController {

  @Autowired
  private IMemberCostService memberCostServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param memberCost ${table.comment}
   * @return
   */
  @GetMapping("/membercosts" )
  public XfR getMemberCosts(XfPage page, MemberCost memberCost) {
    return XfR.ok(memberCostServiceImpl.page(page, Wrappers.query(memberCost)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/membercosts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(memberCostServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param memberCost ${table.comment}
   * @return XfR
   */
  @PostMapping("/membercosts")
  public XfR save(@RequestBody MemberCost memberCost) {
     return XfR.ok(memberCostServiceImpl.save(memberCost));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param memberCost ${table.comment}
   * @return XfR
   */
  @PutMapping("/membercosts/{id}")
  public XfR putUpdate(@RequestBody MemberCost memberCost,@PathVariable Long id) {
      memberCost.setId(id);
      return XfR.ok(memberCostServiceImpl.updateById(memberCost));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param memberCost ${table.comment}
   * @return XfR
   */
  @PatchMapping("/membercosts/{id}")
  public XfR patchUpdate(@RequestBody MemberCost memberCost,@PathVariable Long id) {
      MemberCost upmemberCost = memberCostServiceImpl.getById(id);
      if(upmemberCost != null){
        upmemberCost = ObjectCopyUtils.copyProperties(memberCost,upmemberCost,true);
      }
      return XfR.ok(memberCostServiceImpl.updateById(upmemberCost));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/membercosts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(memberCostServiceImpl.removeById(id));
  }

  @PostMapping("/membercosts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "member_cost");
     params.put("request", condition);

     return XfR.ok(memberCostServiceImpl.querys(params));
  }

}
