package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.MemberShareCost;
import com.xforceplus.ultraman.app.financialsettlement.service.IMemberShareCostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class MemberShareCostController {

  @Autowired
  private IMemberShareCostService memberShareCostServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param memberShareCost ${table.comment}
   * @return
   */
  @GetMapping("/membersharecosts" )
  public XfR getMemberShareCosts(XfPage page, MemberShareCost memberShareCost) {
    return XfR.ok(memberShareCostServiceImpl.page(page, Wrappers.query(memberShareCost)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/membersharecosts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(memberShareCostServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param memberShareCost ${table.comment}
   * @return XfR
   */
  @PostMapping("/membersharecosts")
  public XfR save(@RequestBody MemberShareCost memberShareCost) {
     return XfR.ok(memberShareCostServiceImpl.save(memberShareCost));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param memberShareCost ${table.comment}
   * @return XfR
   */
  @PutMapping("/membersharecosts/{id}")
  public XfR putUpdate(@RequestBody MemberShareCost memberShareCost,@PathVariable Long id) {
      memberShareCost.setId(id);
      return XfR.ok(memberShareCostServiceImpl.updateById(memberShareCost));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param memberShareCost ${table.comment}
   * @return XfR
   */
  @PatchMapping("/membersharecosts/{id}")
  public XfR patchUpdate(@RequestBody MemberShareCost memberShareCost,@PathVariable Long id) {
      MemberShareCost upmemberShareCost = memberShareCostServiceImpl.getById(id);
      if(upmemberShareCost != null){
        upmemberShareCost = ObjectCopyUtils.copyProperties(memberShareCost,upmemberShareCost,true);
      }
      return XfR.ok(memberShareCostServiceImpl.updateById(upmemberShareCost));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/membersharecosts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(memberShareCostServiceImpl.removeById(id));
  }

  @PostMapping("/membersharecosts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "member_share_cost");
     params.put("request", condition);

     return XfR.ok(memberShareCostServiceImpl.querys(params));
  }

}
