package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ReconciliationData;
import com.xforceplus.ultraman.app.financialsettlement.service.IReconciliationDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 结算对账单数据-(废弃)前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class ReconciliationDataController {

  @Autowired
  private IReconciliationDataService reconciliationDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconciliationData 结算对账单数据-(废弃)
   * @return
   */
  @GetMapping("/reconciliationdatas" )
  public XfR getReconciliationDatas(XfPage page, ReconciliationData reconciliationData) {
    return XfR.ok(reconciliationDataServiceImpl.page(page, Wrappers.query(reconciliationData)));
  }

  /**
   * 通过id查询结算对账单数据-(废弃)
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconciliationdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconciliationDataServiceImpl.getById(id));
  }

  /**
   * 新增结算对账单数据-(废弃)
   * @param reconciliationData 结算对账单数据-(废弃)
   * @return XfR
   */
  @PostMapping("/reconciliationdatas")
  public XfR save(@RequestBody ReconciliationData reconciliationData) {
     return XfR.ok(reconciliationDataServiceImpl.save(reconciliationData));
  }

  /**
   * 修改-传入修改后的全部数据结算对账单数据-(废弃)
   * @param reconciliationData 结算对账单数据-(废弃)
   * @return XfR
   */
  @PutMapping("/reconciliationdatas/{id}")
  public XfR putUpdate(@RequestBody ReconciliationData reconciliationData,@PathVariable Long id) {
      reconciliationData.setId(id);
      return XfR.ok(reconciliationDataServiceImpl.updateById(reconciliationData));
  }

  /**
   * 修改-传入修改的数据结算对账单数据-(废弃)
   * @param reconciliationData 结算对账单数据-(废弃)
   * @return XfR
   */
  @PatchMapping("/reconciliationdatas/{id}")
  public XfR patchUpdate(@RequestBody ReconciliationData reconciliationData,@PathVariable Long id) {
      ReconciliationData upreconciliationData = reconciliationDataServiceImpl.getById(id);
      if(upreconciliationData != null){
        upreconciliationData = ObjectCopyUtils.copyProperties(reconciliationData,upreconciliationData,true);
      }
      return XfR.ok(reconciliationDataServiceImpl.updateById(upreconciliationData));
  }

  /**
   * 通过id删除结算对账单数据-(废弃)
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconciliationdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconciliationDataServiceImpl.removeById(id));
  }

  @PostMapping("/reconciliationdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "reconciliation_data");
     params.put("request", condition);

     return XfR.ok(reconciliationDataServiceImpl.querys(params));
  }

}
