package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.BillAttachment;
import com.xforceplus.ultraman.app.financialsettlement.service.IBillAttachmentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-18
 */
@RestController
public class BillAttachmentController {

  @Autowired
  private IBillAttachmentService billAttachmentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billAttachment ${table.comment}
   * @return
   */
  @GetMapping("/billattachments" )
  public XfR getBillAttachments(XfPage page, BillAttachment billAttachment) {
    return XfR.ok(billAttachmentServiceImpl.page(page, Wrappers.query(billAttachment)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billattachments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billAttachmentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billAttachment ${table.comment}
   * @return XfR
   */
  @PostMapping("/billattachments")
  public XfR save(@RequestBody BillAttachment billAttachment) {
     return XfR.ok(billAttachmentServiceImpl.save(billAttachment));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billAttachment ${table.comment}
   * @return XfR
   */
  @PutMapping("/billattachments/{id}")
  public XfR putUpdate(@RequestBody BillAttachment billAttachment,@PathVariable Long id) {
      billAttachment.setId(id);
      return XfR.ok(billAttachmentServiceImpl.updateById(billAttachment));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billAttachment ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billattachments/{id}")
  public XfR patchUpdate(@RequestBody BillAttachment billAttachment,@PathVariable Long id) {
      BillAttachment upbillAttachment = billAttachmentServiceImpl.getById(id);
      if(upbillAttachment != null){
        upbillAttachment = ObjectCopyUtils.copyProperties(billAttachment,upbillAttachment,true);
      }
      return XfR.ok(billAttachmentServiceImpl.updateById(upbillAttachment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billattachments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billAttachmentServiceImpl.removeById(id));
  }

  @PostMapping("/billattachments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_attachment");
     params.put("request", condition);

     return XfR.ok(billAttachmentServiceImpl.querys(params));
  }

}
