package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialLaborUnionBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialLaborUnionBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-18
 */
@RestController
public class FinancialLaborUnionBillController {

  @Autowired
  private IFinancialLaborUnionBillService financialLaborUnionBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialLaborUnionBill ${table.comment}
   * @return
   */
  @GetMapping("/financiallaborunionbills" )
  public XfR getFinancialLaborUnionBills(XfPage page, FinancialLaborUnionBill financialLaborUnionBill) {
    return XfR.ok(financialLaborUnionBillServiceImpl.page(page, Wrappers.query(financialLaborUnionBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financiallaborunionbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialLaborUnionBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialLaborUnionBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financiallaborunionbills")
  public XfR save(@RequestBody FinancialLaborUnionBill financialLaborUnionBill) {
     return XfR.ok(financialLaborUnionBillServiceImpl.save(financialLaborUnionBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialLaborUnionBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financiallaborunionbills/{id}")
  public XfR putUpdate(@RequestBody FinancialLaborUnionBill financialLaborUnionBill,@PathVariable Long id) {
      financialLaborUnionBill.setId(id);
      return XfR.ok(financialLaborUnionBillServiceImpl.updateById(financialLaborUnionBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialLaborUnionBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financiallaborunionbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialLaborUnionBill financialLaborUnionBill,@PathVariable Long id) {
      FinancialLaborUnionBill upfinancialLaborUnionBill = financialLaborUnionBillServiceImpl.getById(id);
      if(upfinancialLaborUnionBill != null){
        upfinancialLaborUnionBill = ObjectCopyUtils.copyProperties(financialLaborUnionBill,upfinancialLaborUnionBill,true);
      }
      return XfR.ok(financialLaborUnionBillServiceImpl.updateById(upfinancialLaborUnionBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financiallaborunionbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialLaborUnionBillServiceImpl.removeById(id));
  }

  @PostMapping("/financiallaborunionbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_labor_union_bill");
     params.put("request", condition);

     return XfR.ok(financialLaborUnionBillServiceImpl.querys(params));
  }

}
