package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.OrderBillRelation;
import com.xforceplus.ultraman.app.financialsettlement.service.IOrderBillRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-18
 */
@RestController
public class OrderBillRelationController {

  @Autowired
  private IOrderBillRelationService orderBillRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderBillRelation ${table.comment}
   * @return
   */
  @GetMapping("/orderbillrelations" )
  public XfR getOrderBillRelations(XfPage page, OrderBillRelation orderBillRelation) {
    return XfR.ok(orderBillRelationServiceImpl.page(page, Wrappers.query(orderBillRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderbillrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderBillRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderBillRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderbillrelations")
  public XfR save(@RequestBody OrderBillRelation orderBillRelation) {
     return XfR.ok(orderBillRelationServiceImpl.save(orderBillRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderBillRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderbillrelations/{id}")
  public XfR putUpdate(@RequestBody OrderBillRelation orderBillRelation,@PathVariable Long id) {
      orderBillRelation.setId(id);
      return XfR.ok(orderBillRelationServiceImpl.updateById(orderBillRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderBillRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderbillrelations/{id}")
  public XfR patchUpdate(@RequestBody OrderBillRelation orderBillRelation,@PathVariable Long id) {
      OrderBillRelation uporderBillRelation = orderBillRelationServiceImpl.getById(id);
      if(uporderBillRelation != null){
        uporderBillRelation = ObjectCopyUtils.copyProperties(orderBillRelation,uporderBillRelation,true);
      }
      return XfR.ok(orderBillRelationServiceImpl.updateById(uporderBillRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderbillrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderBillRelationServiceImpl.removeById(id));
  }

  @PostMapping("/orderbillrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_bill_relation");
     params.put("request", condition);

     return XfR.ok(orderBillRelationServiceImpl.querys(params));
  }

}
