package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeCodeBudget;
import com.xforceplus.ultraman.app.financialsettlement.service.IChargeCodeBudgetService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-04
 */
@RestController
public class ChargeCodeBudgetController {

  @Autowired
  private IChargeCodeBudgetService chargeCodeBudgetServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeBudget ${table.comment}
   * @return
   */
  @GetMapping("/chargecodebudgets" )
  public XfR getChargeCodeBudgets(XfPage page, ChargeCodeBudget chargeCodeBudget) {
    return XfR.ok(chargeCodeBudgetServiceImpl.page(page, Wrappers.query(chargeCodeBudget)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodebudgets/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCodeBudget ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodebudgets")
  public XfR save(@RequestBody ChargeCodeBudget chargeCodeBudget) {
     return XfR.ok(chargeCodeBudgetServiceImpl.save(chargeCodeBudget));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCodeBudget ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodebudgets/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeBudget chargeCodeBudget,@PathVariable Long id) {
      chargeCodeBudget.setId(id);
      return XfR.ok(chargeCodeBudgetServiceImpl.updateById(chargeCodeBudget));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCodeBudget ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodebudgets/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeBudget chargeCodeBudget,@PathVariable Long id) {
      ChargeCodeBudget upchargeCodeBudget = chargeCodeBudgetServiceImpl.getById(id);
      if(upchargeCodeBudget != null){
        upchargeCodeBudget = ObjectCopyUtils.copyProperties(chargeCodeBudget,upchargeCodeBudget,true);
      }
      return XfR.ok(chargeCodeBudgetServiceImpl.updateById(upchargeCodeBudget));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodebudgets/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodebudgets/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_budget");
     params.put("request", condition);

     return XfR.ok(chargeCodeBudgetServiceImpl.querys(params));
  }

}
