package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialKeeperChangeBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialKeeperChangeBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 保管人变更申请单明细前端控制器
 *
 * @author ultraman
 * @date 2024-03-04
 */
@RestController
public class FinancialKeeperChangeBillDetailController {

  @Autowired
  private IFinancialKeeperChangeBillDetailService financialKeeperChangeBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialKeeperChangeBillDetail 保管人变更申请单明细
   * @return
   */
  @GetMapping("/financialkeeperchangebilldetails" )
  public XfR getFinancialKeeperChangeBillDetails(XfPage page, FinancialKeeperChangeBillDetail financialKeeperChangeBillDetail) {
    return XfR.ok(financialKeeperChangeBillDetailServiceImpl.page(page, Wrappers.query(financialKeeperChangeBillDetail)));
  }

  /**
   * 通过id查询保管人变更申请单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialkeeperchangebilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialKeeperChangeBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增保管人变更申请单明细
   * @param financialKeeperChangeBillDetail 保管人变更申请单明细
   * @return XfR
   */
  @PostMapping("/financialkeeperchangebilldetails")
  public XfR save(@RequestBody FinancialKeeperChangeBillDetail financialKeeperChangeBillDetail) {
     return XfR.ok(financialKeeperChangeBillDetailServiceImpl.save(financialKeeperChangeBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据保管人变更申请单明细
   * @param financialKeeperChangeBillDetail 保管人变更申请单明细
   * @return XfR
   */
  @PutMapping("/financialkeeperchangebilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialKeeperChangeBillDetail financialKeeperChangeBillDetail,@PathVariable Long id) {
      financialKeeperChangeBillDetail.setId(id);
      return XfR.ok(financialKeeperChangeBillDetailServiceImpl.updateById(financialKeeperChangeBillDetail));
  }

  /**
   * 修改-传入修改的数据保管人变更申请单明细
   * @param financialKeeperChangeBillDetail 保管人变更申请单明细
   * @return XfR
   */
  @PatchMapping("/financialkeeperchangebilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialKeeperChangeBillDetail financialKeeperChangeBillDetail,@PathVariable Long id) {
      FinancialKeeperChangeBillDetail upfinancialKeeperChangeBillDetail = financialKeeperChangeBillDetailServiceImpl.getById(id);
      if(upfinancialKeeperChangeBillDetail != null){
        upfinancialKeeperChangeBillDetail = ObjectCopyUtils.copyProperties(financialKeeperChangeBillDetail,upfinancialKeeperChangeBillDetail,true);
      }
      return XfR.ok(financialKeeperChangeBillDetailServiceImpl.updateById(upfinancialKeeperChangeBillDetail));
  }

  /**
   * 通过id删除保管人变更申请单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialkeeperchangebilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialKeeperChangeBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialkeeperchangebilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_keeper_change_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialKeeperChangeBillDetailServiceImpl.querys(params));
  }

}
