package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialPurchaseRedAdjustBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialPurchaseRedAdjustBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-04
 */
@RestController
public class FinancialPurchaseRedAdjustBillController {

  @Autowired
  private IFinancialPurchaseRedAdjustBillService financialPurchaseRedAdjustBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPurchaseRedAdjustBill ${table.comment}
   * @return
   */
  @GetMapping("/financialpurchaseredadjustbills" )
  public XfR getFinancialPurchaseRedAdjustBills(XfPage page, FinancialPurchaseRedAdjustBill financialPurchaseRedAdjustBill) {
    return XfR.ok(financialPurchaseRedAdjustBillServiceImpl.page(page, Wrappers.query(financialPurchaseRedAdjustBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpurchaseredadjustbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseRedAdjustBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialPurchaseRedAdjustBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialpurchaseredadjustbills")
  public XfR save(@RequestBody FinancialPurchaseRedAdjustBill financialPurchaseRedAdjustBill) {
     return XfR.ok(financialPurchaseRedAdjustBillServiceImpl.save(financialPurchaseRedAdjustBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialPurchaseRedAdjustBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialpurchaseredadjustbills/{id}")
  public XfR putUpdate(@RequestBody FinancialPurchaseRedAdjustBill financialPurchaseRedAdjustBill,@PathVariable Long id) {
      financialPurchaseRedAdjustBill.setId(id);
      return XfR.ok(financialPurchaseRedAdjustBillServiceImpl.updateById(financialPurchaseRedAdjustBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialPurchaseRedAdjustBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialpurchaseredadjustbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialPurchaseRedAdjustBill financialPurchaseRedAdjustBill,@PathVariable Long id) {
      FinancialPurchaseRedAdjustBill upfinancialPurchaseRedAdjustBill = financialPurchaseRedAdjustBillServiceImpl.getById(id);
      if(upfinancialPurchaseRedAdjustBill != null){
        upfinancialPurchaseRedAdjustBill = ObjectCopyUtils.copyProperties(financialPurchaseRedAdjustBill,upfinancialPurchaseRedAdjustBill,true);
      }
      return XfR.ok(financialPurchaseRedAdjustBillServiceImpl.updateById(upfinancialPurchaseRedAdjustBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpurchaseredadjustbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseRedAdjustBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialpurchaseredadjustbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_purchase_red_adjust_bill");
     params.put("request", condition);

     return XfR.ok(financialPurchaseRedAdjustBillServiceImpl.querys(params));
  }

}
