package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialWriteoffBasicBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialWriteoffBasicBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-04
 */
@RestController
public class FinancialWriteoffBasicBillController {

  @Autowired
  private IFinancialWriteoffBasicBillService financialWriteoffBasicBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialWriteoffBasicBill ${table.comment}
   * @return
   */
  @GetMapping("/financialwriteoffbasicbills" )
  public XfR getFinancialWriteoffBasicBills(XfPage page, FinancialWriteoffBasicBill financialWriteoffBasicBill) {
    return XfR.ok(financialWriteoffBasicBillServiceImpl.page(page, Wrappers.query(financialWriteoffBasicBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialwriteoffbasicbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialWriteoffBasicBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialWriteoffBasicBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialwriteoffbasicbills")
  public XfR save(@RequestBody FinancialWriteoffBasicBill financialWriteoffBasicBill) {
     return XfR.ok(financialWriteoffBasicBillServiceImpl.save(financialWriteoffBasicBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialWriteoffBasicBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialwriteoffbasicbills/{id}")
  public XfR putUpdate(@RequestBody FinancialWriteoffBasicBill financialWriteoffBasicBill,@PathVariable Long id) {
      financialWriteoffBasicBill.setId(id);
      return XfR.ok(financialWriteoffBasicBillServiceImpl.updateById(financialWriteoffBasicBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialWriteoffBasicBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialwriteoffbasicbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialWriteoffBasicBill financialWriteoffBasicBill,@PathVariable Long id) {
      FinancialWriteoffBasicBill upfinancialWriteoffBasicBill = financialWriteoffBasicBillServiceImpl.getById(id);
      if(upfinancialWriteoffBasicBill != null){
        upfinancialWriteoffBasicBill = ObjectCopyUtils.copyProperties(financialWriteoffBasicBill,upfinancialWriteoffBasicBill,true);
      }
      return XfR.ok(financialWriteoffBasicBillServiceImpl.updateById(upfinancialWriteoffBasicBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialwriteoffbasicbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialWriteoffBasicBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialwriteoffbasicbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_writeoff_basic_bill");
     params.put("request", condition);

     return XfR.ok(financialWriteoffBasicBillServiceImpl.querys(params));
  }

}
