package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialRfOther;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialRfOtherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 *  退款申请单「其他」前端控制器
 *
 * @author ultraman
 * @date 2024-03-20
 */
@RestController
public class FinancialRfOtherController {

  @Autowired
  private IFinancialRfOtherService financialRfOtherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialRfOther  退款申请单「其他」
   * @return
   */
  @GetMapping("/financialrfothers" )
  public XfR getFinancialRfOthers(XfPage page, FinancialRfOther financialRfOther) {
    return XfR.ok(financialRfOtherServiceImpl.page(page, Wrappers.query(financialRfOther)));
  }

  /**
   * 通过id查询 退款申请单「其他」
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialrfothers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialRfOtherServiceImpl.getById(id));
  }

  /**
   * 新增 退款申请单「其他」
   * @param financialRfOther  退款申请单「其他」
   * @return XfR
   */
  @PostMapping("/financialrfothers")
  public XfR save(@RequestBody FinancialRfOther financialRfOther) {
     return XfR.ok(financialRfOtherServiceImpl.save(financialRfOther));
  }

  /**
   * 修改-传入修改后的全部数据 退款申请单「其他」
   * @param financialRfOther  退款申请单「其他」
   * @return XfR
   */
  @PutMapping("/financialrfothers/{id}")
  public XfR putUpdate(@RequestBody FinancialRfOther financialRfOther,@PathVariable Long id) {
      financialRfOther.setId(id);
      return XfR.ok(financialRfOtherServiceImpl.updateById(financialRfOther));
  }

  /**
   * 修改-传入修改的数据 退款申请单「其他」
   * @param financialRfOther  退款申请单「其他」
   * @return XfR
   */
  @PatchMapping("/financialrfothers/{id}")
  public XfR patchUpdate(@RequestBody FinancialRfOther financialRfOther,@PathVariable Long id) {
      FinancialRfOther upfinancialRfOther = financialRfOtherServiceImpl.getById(id);
      if(upfinancialRfOther != null){
        upfinancialRfOther = ObjectCopyUtils.copyProperties(financialRfOther,upfinancialRfOther,true);
      }
      return XfR.ok(financialRfOtherServiceImpl.updateById(upfinancialRfOther));
  }

  /**
   * 通过id删除 退款申请单「其他」
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialrfothers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialRfOtherServiceImpl.removeById(id));
  }

  @PostMapping("/financialrfothers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_rf_other");
     params.put("request", condition);

     return XfR.ok(financialRfOtherServiceImpl.querys(params));
  }

}
