package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialSalaryBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialSalaryBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-20
 */
@RestController
public class FinancialSalaryBillDetailController {

  @Autowired
  private IFinancialSalaryBillDetailService financialSalaryBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialSalaryBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialsalarybilldetails" )
  public XfR getFinancialSalaryBillDetails(XfPage page, FinancialSalaryBillDetail financialSalaryBillDetail) {
    return XfR.ok(financialSalaryBillDetailServiceImpl.page(page, Wrappers.query(financialSalaryBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialsalarybilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialSalaryBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialSalaryBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialsalarybilldetails")
  public XfR save(@RequestBody FinancialSalaryBillDetail financialSalaryBillDetail) {
     return XfR.ok(financialSalaryBillDetailServiceImpl.save(financialSalaryBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialSalaryBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialsalarybilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialSalaryBillDetail financialSalaryBillDetail,@PathVariable Long id) {
      financialSalaryBillDetail.setId(id);
      return XfR.ok(financialSalaryBillDetailServiceImpl.updateById(financialSalaryBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialSalaryBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialsalarybilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialSalaryBillDetail financialSalaryBillDetail,@PathVariable Long id) {
      FinancialSalaryBillDetail upfinancialSalaryBillDetail = financialSalaryBillDetailServiceImpl.getById(id);
      if(upfinancialSalaryBillDetail != null){
        upfinancialSalaryBillDetail = ObjectCopyUtils.copyProperties(financialSalaryBillDetail,upfinancialSalaryBillDetail,true);
      }
      return XfR.ok(financialSalaryBillDetailServiceImpl.updateById(upfinancialSalaryBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialsalarybilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialSalaryBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialsalarybilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_salary_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialSalaryBillDetailServiceImpl.querys(params));
  }

}
