package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.StatisticsReportEmail;
import com.xforceplus.ultraman.app.financialsettlement.service.IStatisticsReportEmailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-20
 */
@RestController
public class StatisticsReportEmailController {

  @Autowired
  private IStatisticsReportEmailService statisticsReportEmailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param statisticsReportEmail ${table.comment}
   * @return
   */
  @GetMapping("/statisticsreportemails" )
  public XfR getStatisticsReportEmails(XfPage page, StatisticsReportEmail statisticsReportEmail) {
    return XfR.ok(statisticsReportEmailServiceImpl.page(page, Wrappers.query(statisticsReportEmail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/statisticsreportemails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(statisticsReportEmailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param statisticsReportEmail ${table.comment}
   * @return XfR
   */
  @PostMapping("/statisticsreportemails")
  public XfR save(@RequestBody StatisticsReportEmail statisticsReportEmail) {
     return XfR.ok(statisticsReportEmailServiceImpl.save(statisticsReportEmail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param statisticsReportEmail ${table.comment}
   * @return XfR
   */
  @PutMapping("/statisticsreportemails/{id}")
  public XfR putUpdate(@RequestBody StatisticsReportEmail statisticsReportEmail,@PathVariable Long id) {
      statisticsReportEmail.setId(id);
      return XfR.ok(statisticsReportEmailServiceImpl.updateById(statisticsReportEmail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param statisticsReportEmail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/statisticsreportemails/{id}")
  public XfR patchUpdate(@RequestBody StatisticsReportEmail statisticsReportEmail,@PathVariable Long id) {
      StatisticsReportEmail upstatisticsReportEmail = statisticsReportEmailServiceImpl.getById(id);
      if(upstatisticsReportEmail != null){
        upstatisticsReportEmail = ObjectCopyUtils.copyProperties(statisticsReportEmail,upstatisticsReportEmail,true);
      }
      return XfR.ok(statisticsReportEmailServiceImpl.updateById(upstatisticsReportEmail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/statisticsreportemails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(statisticsReportEmailServiceImpl.removeById(id));
  }

  @PostMapping("/statisticsreportemails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "statistics_report_email");
     params.put("request", condition);

     return XfR.ok(statisticsReportEmailServiceImpl.querys(params));
  }

}
