package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.BillInvoice;
import com.xforceplus.ultraman.app.financialsettlement.service.IBillInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-28
 */
@RestController
public class BillInvoiceController {

  @Autowired
  private IBillInvoiceService billInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billInvoice ${table.comment}
   * @return
   */
  @GetMapping("/billinvoices" )
  public XfR getBillInvoices(XfPage page, BillInvoice billInvoice) {
    return XfR.ok(billInvoiceServiceImpl.page(page, Wrappers.query(billInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/billinvoices")
  public XfR save(@RequestBody BillInvoice billInvoice) {
     return XfR.ok(billInvoiceServiceImpl.save(billInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/billinvoices/{id}")
  public XfR putUpdate(@RequestBody BillInvoice billInvoice,@PathVariable Long id) {
      billInvoice.setId(id);
      return XfR.ok(billInvoiceServiceImpl.updateById(billInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billinvoices/{id}")
  public XfR patchUpdate(@RequestBody BillInvoice billInvoice,@PathVariable Long id) {
      BillInvoice upbillInvoice = billInvoiceServiceImpl.getById(id);
      if(upbillInvoice != null){
        upbillInvoice = ObjectCopyUtils.copyProperties(billInvoice,upbillInvoice,true);
      }
      return XfR.ok(billInvoiceServiceImpl.updateById(upbillInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/billinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_invoice");
     params.put("request", condition);

     return XfR.ok(billInvoiceServiceImpl.querys(params));
  }

}
