package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialBasicBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialBasicBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-28
 */
@RestController
public class FinancialBasicBillDetailController {

  @Autowired
  private IFinancialBasicBillDetailService financialBasicBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialBasicBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialbasicbilldetails" )
  public XfR getFinancialBasicBillDetails(XfPage page, FinancialBasicBillDetail financialBasicBillDetail) {
    return XfR.ok(financialBasicBillDetailServiceImpl.page(page, Wrappers.query(financialBasicBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialbasicbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialBasicBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialBasicBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialbasicbilldetails")
  public XfR save(@RequestBody FinancialBasicBillDetail financialBasicBillDetail) {
     return XfR.ok(financialBasicBillDetailServiceImpl.save(financialBasicBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialBasicBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialbasicbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialBasicBillDetail financialBasicBillDetail,@PathVariable Long id) {
      financialBasicBillDetail.setId(id);
      return XfR.ok(financialBasicBillDetailServiceImpl.updateById(financialBasicBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialBasicBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialbasicbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialBasicBillDetail financialBasicBillDetail,@PathVariable Long id) {
      FinancialBasicBillDetail upfinancialBasicBillDetail = financialBasicBillDetailServiceImpl.getById(id);
      if(upfinancialBasicBillDetail != null){
        upfinancialBasicBillDetail = ObjectCopyUtils.copyProperties(financialBasicBillDetail,upfinancialBasicBillDetail,true);
      }
      return XfR.ok(financialBasicBillDetailServiceImpl.updateById(upfinancialBasicBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialbasicbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialBasicBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialbasicbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_basic_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialBasicBillDetailServiceImpl.querys(params));
  }

}
