package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialBasicBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialBasicBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-07
 */
@RestController
public class FinancialBasicBillController {

  @Autowired
  private IFinancialBasicBillService financialBasicBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialBasicBill ${table.comment}
   * @return
   */
  @GetMapping("/financialbasicbills" )
  public XfR getFinancialBasicBills(XfPage page, FinancialBasicBill financialBasicBill) {
    return XfR.ok(financialBasicBillServiceImpl.page(page, Wrappers.query(financialBasicBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialbasicbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialBasicBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialBasicBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialbasicbills")
  public XfR save(@RequestBody FinancialBasicBill financialBasicBill) {
     return XfR.ok(financialBasicBillServiceImpl.save(financialBasicBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialBasicBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialbasicbills/{id}")
  public XfR putUpdate(@RequestBody FinancialBasicBill financialBasicBill,@PathVariable Long id) {
      financialBasicBill.setId(id);
      return XfR.ok(financialBasicBillServiceImpl.updateById(financialBasicBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialBasicBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialbasicbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialBasicBill financialBasicBill,@PathVariable Long id) {
      FinancialBasicBill upfinancialBasicBill = financialBasicBillServiceImpl.getById(id);
      if(upfinancialBasicBill != null){
        upfinancialBasicBill = ObjectCopyUtils.copyProperties(financialBasicBill,upfinancialBasicBill,true);
      }
      return XfR.ok(financialBasicBillServiceImpl.updateById(upfinancialBasicBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialbasicbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialBasicBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialbasicbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_basic_bill");
     params.put("request", condition);

     return XfR.ok(financialBasicBillServiceImpl.querys(params));
  }

}
