package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialDailyBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialDailyBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 日常报销单明细前端控制器
 *
 * @author ultraman
 * @date 2022-07-07
 */
@RestController
public class FinancialDailyBillDetailController {

  @Autowired
  private IFinancialDailyBillDetailService financialDailyBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialDailyBillDetail 日常报销单明细
   * @return
   */
  @GetMapping("/financialdailybilldetails" )
  public XfR getFinancialDailyBillDetails(XfPage page, FinancialDailyBillDetail financialDailyBillDetail) {
    return XfR.ok(financialDailyBillDetailServiceImpl.page(page, Wrappers.query(financialDailyBillDetail)));
  }

  /**
   * 通过id查询日常报销单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialdailybilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialDailyBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增日常报销单明细
   * @param financialDailyBillDetail 日常报销单明细
   * @return XfR
   */
  @PostMapping("/financialdailybilldetails")
  public XfR save(@RequestBody FinancialDailyBillDetail financialDailyBillDetail) {
     return XfR.ok(financialDailyBillDetailServiceImpl.save(financialDailyBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据日常报销单明细
   * @param financialDailyBillDetail 日常报销单明细
   * @return XfR
   */
  @PutMapping("/financialdailybilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialDailyBillDetail financialDailyBillDetail,@PathVariable Long id) {
      financialDailyBillDetail.setId(id);
      return XfR.ok(financialDailyBillDetailServiceImpl.updateById(financialDailyBillDetail));
  }

  /**
   * 修改-传入修改的数据日常报销单明细
   * @param financialDailyBillDetail 日常报销单明细
   * @return XfR
   */
  @PatchMapping("/financialdailybilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialDailyBillDetail financialDailyBillDetail,@PathVariable Long id) {
      FinancialDailyBillDetail upfinancialDailyBillDetail = financialDailyBillDetailServiceImpl.getById(id);
      if(upfinancialDailyBillDetail != null){
        upfinancialDailyBillDetail = ObjectCopyUtils.copyProperties(financialDailyBillDetail,upfinancialDailyBillDetail,true);
      }
      return XfR.ok(financialDailyBillDetailServiceImpl.updateById(upfinancialDailyBillDetail));
  }

  /**
   * 通过id删除日常报销单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialdailybilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialDailyBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialdailybilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_daily_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialDailyBillDetailServiceImpl.querys(params));
  }

}
