package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialTravelBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialTravelBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-07
 */
@RestController
public class FinancialTravelBillDetailController {

  @Autowired
  private IFinancialTravelBillDetailService financialTravelBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialTravelBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialtravelbilldetails" )
  public XfR getFinancialTravelBillDetails(XfPage page, FinancialTravelBillDetail financialTravelBillDetail) {
    return XfR.ok(financialTravelBillDetailServiceImpl.page(page, Wrappers.query(financialTravelBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialtravelbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialTravelBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialTravelBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialtravelbilldetails")
  public XfR save(@RequestBody FinancialTravelBillDetail financialTravelBillDetail) {
     return XfR.ok(financialTravelBillDetailServiceImpl.save(financialTravelBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialTravelBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialtravelbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialTravelBillDetail financialTravelBillDetail,@PathVariable Long id) {
      financialTravelBillDetail.setId(id);
      return XfR.ok(financialTravelBillDetailServiceImpl.updateById(financialTravelBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialTravelBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialtravelbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialTravelBillDetail financialTravelBillDetail,@PathVariable Long id) {
      FinancialTravelBillDetail upfinancialTravelBillDetail = financialTravelBillDetailServiceImpl.getById(id);
      if(upfinancialTravelBillDetail != null){
        upfinancialTravelBillDetail = ObjectCopyUtils.copyProperties(financialTravelBillDetail,upfinancialTravelBillDetail,true);
      }
      return XfR.ok(financialTravelBillDetailServiceImpl.updateById(upfinancialTravelBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialtravelbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialTravelBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialtravelbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_travel_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialTravelBillDetailServiceImpl.querys(params));
  }

}
