/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.app.flowmq.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.app.flowmq.entity.TodoTask;
import com.xforceplus.ultraman.app.flowmq.service.ITodoTaskService;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TodoTaskController {
    @Autowired
    private ITodoTaskService todoTaskServiceImpl;

    @GetMapping(value={"/todotasks"})
    public XfR getTodoTasks(XfPage page, TodoTask todoTask) {
        return XfR.ok((Object)this.todoTaskServiceImpl.page((IPage)page, (Wrapper)Wrappers.query((Object)todoTask)));
    }

    @GetMapping(value={"/todotasks/{id}"})
    public XfR getById(@PathVariable Long id) {
        return XfR.ok((Object)this.todoTaskServiceImpl.getById(id));
    }

    @PostMapping(value={"/todotasks"})
    public XfR save(@RequestBody TodoTask todoTask) {
        return XfR.ok((Object)this.todoTaskServiceImpl.save(todoTask));
    }

    @PutMapping(value={"/todotasks/{id}"})
    public XfR putUpdate(@RequestBody TodoTask todoTask, @PathVariable Long id) {
        todoTask.setId(id);
        return XfR.ok((Object)this.todoTaskServiceImpl.updateById(todoTask));
    }

    @PatchMapping(value={"/todotasks/{id}"})
    public XfR patchUpdate(@RequestBody TodoTask todoTask, @PathVariable Long id) {
        TodoTask uptodoTask = (TodoTask)this.todoTaskServiceImpl.getById(id);
        if (uptodoTask != null) {
            uptodoTask = (TodoTask)ObjectCopyUtils.copyProperties((Object)todoTask, (Object)uptodoTask, (boolean)true);
        }
        return XfR.ok((Object)this.todoTaskServiceImpl.updateById(uptodoTask));
    }

    @DeleteMapping(value={"/todotasks/{id}"})
    public XfR removeById(@PathVariable Long id) {
        return XfR.ok((Object)this.todoTaskServiceImpl.removeById(id));
    }

    @PostMapping(value={"/todotasks/query"})
    public XfR querys(@RequestBody ConditionQueryRequest condition) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", "todo_task");
        params.put("request", condition);
        return XfR.ok(this.todoTaskServiceImpl.querys(params));
    }
}

