package com.xforceplus.ultraman.app.gemini.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_source
 * </p>
 *
 * @author ultraman
 * @since 2025-02-17
 */
public enum BillSource {

    ARTERY("ARTERY", "统一单据池");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillSource fromCode(String code){
        switch(code) {
            case "ARTERY":
                return ARTERY;
            default:
                return null;
        }
    }
}
