package com.xforceplus.ultraman.app.gemini.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_type
 * </p>
 *
 * @author ultraman
 * @since 2025-02-17
 */
public enum BillType {

    GOODS_RECEIVE_NOTE("GOODS_RECEIVE_NOTE", "收货单"),
    RETURN_TO_VENDOR("RETURN_TO_VENDOR", "退货单"),
    BILLING("BILLING", "billing单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillType fromCode(String code){
        switch(code) {
            case "GOODS_RECEIVE_NOTE":
                return GOODS_RECEIVE_NOTE;
            case "RETURN_TO_VENDOR":
                return RETURN_TO_VENDOR;
            case "BILLING":
                return BILLING;
            default:
                return null;
        }
    }
}
