package com.xforceplus.ultraman.app.gemini.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * lock_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-17
 */
public enum LockStatus {

    UNLOCKED("unlocked", "未锁定"),
    LOCKING("locking", "锁定中"),
    LOCKED("locked", "已锁定");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    LockStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LockStatus fromCode(String code){
        switch(code) {
            case "unlocked":
                return UNLOCKED;
            case "locking":
                return LOCKING;
            case "locked":
                return LOCKED;
            default:
                return null;
        }
    }
}
