package com.xforceplus.ultraman.app.gemini.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recon_scene
 * </p>
 *
 * @author ultraman
 * @since 2025-02-17
 */
public enum ReconScene {

    _1("1", "收发货核对"),
    _2("2", "收发货对账"),
    _3("3", "结算对账");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReconScene(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReconScene fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
