package com.xforceplus.ultraman.app.gemini.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recon_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-17
 */
public enum ReconStatus {

    _0("0", "未对账"),
    _1("1", "对账中"),
    _2("2", "部分对账"),
    _3("3", "待确认"),
    _4("4", "已对账"),
    _5("5", "已失效"),
    __1("-1", "失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReconStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReconStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "-1":
                return __1;
            default:
                return null;
        }
    }
}
