package com.xforceplus.ultraman.app.gemini.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * workflow_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-17
 */
public enum WorkflowStatus {

    _0("0", "进行中"),
    _1("1", "完成"),
    __1("-1", "异常"),
    _2("2", "终止"),
    _3("3", "撤回");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    WorkflowStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WorkflowStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "-1":
                return __1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
