package com.xforceplus.ultraman.app.gemini.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yes_no
 * </p>
 *
 * @author ultraman
 * @since 2025-02-17
 */
public enum YesNo {

    YES("yes", "是"),
    NO("no", "否");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YesNo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YesNo fromCode(String code){
        switch(code) {
            case "yes":
                return YES;
            case "no":
                return NO;
            default:
                return null;
        }
    }
}
