package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_source
 * </p>
 *
 * @author ultraman
 * @since 2025-02-18
 */
public enum BillSource {

    ARTERY("ARTERY", "统一单据池");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillSource fromCode(String code) {
        return Stream.of(BillSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
