package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * miss_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-02-18
 */
public enum MissFlag {

    _0("0", "找到"),
    _1("1", "未找到");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MissFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MissFlag fromCode(String code) {
        return Stream.of(MissFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
