package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recon_type
 * </p>
 *
 * @author ultraman
 * @since 2025-02-18
 */
public enum ReconType {

    _0("0", "自动"),
    _1("1", "线下"),
    _2("2", "手动关联");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReconType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReconType fromCode(String code) {
        return Stream.of(ReconType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
