package com.xforceplus.ultraman.app.gemini.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * recon_batch
 * </p>
 *
 * @author ultraman
 * @since 2025-02-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReconBatch implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 通用批次号
   */
  private String batchNo;
  /**
   * 对账场景
   */
  private String reconScene;
  /**
   * 对账类型
   */
  private String reconType;
  /**
   * 生成批次场景
   */
  private Long batchMode;
  /**
   * 对账策略名称
   */
  private String reconPolicyName;
  /**
   * 对账状态
   */
  private String reconStatus;
  /**
   * 锁定状态
   */
  private String lockStatus;
  /**
   * 锁定时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lockTime;
  /**
   * 解除锁定时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime unlockTime;
  /**
   * 开票结算单id
   */
  private Long issueSettlementId;
  /**
   * 开票结算单编号
   */
  private String issueSettlementNo;
  /**
   * 批次标签
   */
  private String batchTag;
  /**
   * 通过标记
   */
  private String passFlag;
  /**
   * 对账不通过原因
   */
  private String reason;
  /**
   * 结算单号
   */
  private String settlementNo;
  /**
   * 结算单id
   */
  private String settlementId;
  /**
   * 销方公司名称
   */
  private String sellerName;
  /**
   * 销方公司编号
   */
  private String sellerNo;
  /**
   * 销方租户id
   */
  private Long sellerTenantId;
  /**
   * 销方销售组织编码
   */
  private String sellerSalesOrganizationCode;
  /**
   * 销方销售组织名称
   */
  private String sellerSalesOrganizationName;
  /**
   * 销方销售组编码
   */
  private String sellerSalesGroupCode;
  /**
   * 销方销售组名称
   */
  private String sellerSalesGroupName;
  /**
   * 购方公司名称
   */
  private String buyerName;
  /**
   * 购方公司编号
   */
  private String buyerNo;
  /**
   * 商超
   */
  private String buyerRetailerCode;
  /**
   * 商超名称
   */
  private String buyerRetailerName;
  /**
   * 购方租户id
   */
  private Long buyerTenantId;
  /**
   * 采购订单编号
   */
  private String purchaseOrderNo;
  /**
   * 批量包装对账数量
   */
  private BigDecimal packageQuantityFrom;
  /**
   * 批量包装被对账数量
   */
  private BigDecimal packageQuantityTo;
  /**
   * 对账数量
   */
  private BigDecimal quantityFrom;
  /**
   * 被对账数量
   */
  private BigDecimal quantityTo;
  /**
   * 对账含税金额
   */
  private BigDecimal amountWithTaxFrom;
  /**
   * 被对账含税金额
   */
  private BigDecimal amountWithTaxTo;
  /**
   * 对账不含税金额
   */
  private BigDecimal amountWithoutTaxFrom;
  /**
   * 被对账不含税金额
   */
  private BigDecimal amountWithoutTaxTo;
  /**
   * 对账单据类型名称
   */
  private String billTypeNameFrom;
  /**
   * 被对账单据类型名称
   */
  private String billTypeNameTo;
  /**
   * 对账单据号
   */
  private String billNoFrom;
  /**
   * 被对账单据号
   */
  private String billNoTo;
  /**
   * 对账单据日期
   */
  private String billDateFrom;
  /**
   * 被对账单据日期
   */
  private String billDateTo;
  /**
   * 是否计算数量差异
   */
  private String diffQuantityEnable;
  /**
   * 是否存在数量差异
   */
  private String diffQuantityFlag;
  /**
   * 数量差异值
   */
  private BigDecimal diffQuantityValue;
  /**
   * 是否计算箱装量差
   */
  private String diffPackageQuantityEnable;
  /**
   * 是否存在箱装量差
   */
  private String diffPackageQuantityFlag;
  /**
   * 箱装量差值
   */
  private BigDecimal diffPackageQuantityValue;
  /**
   * 是否计算含税单价差异
   */
  private String diffUnitPriceWithTaxEnable;
  /**
   * 是否存在含税单价差异
   */
  private String diffUnitPriceWithTaxFlag;
  /**
   * 是否计算含税箱价差异
   */
  private String diffPackageUnitPriceWithTaxEnable;
  /**
   * 是否存在含税箱价差异
   */
  private String diffPackageUnitPriceWithTaxFlag;
  /**
   * 是否计算含税金额差异
   */
  private String diffAmountWithTaxEnable;
  /**
   * 是否存在含税金额差异
   */
  private String diffAmountWithTaxFlag;
  /**
   * 含税金额差异值
   */
  private BigDecimal diffAmountWithTaxValue;
  /**
   * 是否计算不含税金额差异
   */
  private String diffAmountWithoutTaxEnable;
  /**
   * 是否存在不含税金额差异
   */
  private String diffAmountWithoutTaxFlag;
  /**
   * 不含税金额差异值
   */
  private BigDecimal diffAmountWithoutTaxValue;
  /**
   * 未找到对账单据
   */
  private String missFromBillFlag;
  /**
   * 未找到被对账单据
   */
  private String missToBillFlag;
  /**
   * 商品未匹配
   */
  private String missGoodsFlag;
  /**
   * 是否组套商品
   */
  private String suitFlag;
  /**
   * 是否自然替换商品
   */
  private String newOldFlag;
  /**
   * 差异计算标志
   */
  private String diffEnableFlag;
  /**
   * 对账配置id
   */
  private Long configId;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 差异类型
   */
  private String diffType;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("batch_no", batchNo);
      map.put("recon_scene", reconScene);
      map.put("recon_type", reconType);
      map.put("batch_mode", batchMode);
      map.put("recon_policy_name", reconPolicyName);
      map.put("recon_status", reconStatus);
      map.put("lock_status", lockStatus);
      map.put("lock_time", BocpGenUtils.toTimestamp(lockTime));
      map.put("unlock_time", BocpGenUtils.toTimestamp(unlockTime));
      map.put("issue_settlement_id", issueSettlementId);
      map.put("issue_settlement_no", issueSettlementNo);
      map.put("batch_tag", batchTag);
      map.put("pass_flag", passFlag);
      map.put("reason", reason);
      map.put("settlement_no", settlementNo);
      map.put("settlement_id", settlementId);
      map.put("seller_name", sellerName);
      map.put("seller_no", sellerNo);
      map.put("seller_tenant_id", sellerTenantId);
      map.put("seller_sales_organization_code", sellerSalesOrganizationCode);
      map.put("seller_sales_organization_name", sellerSalesOrganizationName);
      map.put("seller_sales_group_code", sellerSalesGroupCode);
      map.put("seller_sales_group_name", sellerSalesGroupName);
      map.put("buyer_name", buyerName);
      map.put("buyer_no", buyerNo);
      map.put("buyer_retailer_code", buyerRetailerCode);
      map.put("buyer_retailer_name", buyerRetailerName);
      map.put("buyer_tenant_id", buyerTenantId);
      map.put("purchase_order_no", purchaseOrderNo);
      map.put("package_quantity_from", packageQuantityFrom);
      map.put("package_quantity_to", packageQuantityTo);
      map.put("quantity_from", quantityFrom);
      map.put("quantity_to", quantityTo);
      map.put("amount_with_tax_from", amountWithTaxFrom);
      map.put("amount_with_tax_to", amountWithTaxTo);
      map.put("amount_without_tax_from", amountWithoutTaxFrom);
      map.put("amount_without_tax_to", amountWithoutTaxTo);
      map.put("bill_type_name_from", billTypeNameFrom);
      map.put("bill_type_name_to", billTypeNameTo);
      map.put("bill_no_from", billNoFrom);
      map.put("bill_no_to", billNoTo);
      map.put("bill_date_from", billDateFrom);
      map.put("bill_date_to", billDateTo);
      map.put("diff_quantity_enable", diffQuantityEnable);
      map.put("diff_quantity_flag", diffQuantityFlag);
      map.put("diff_quantity_value", diffQuantityValue);
      map.put("diff_package_quantity_enable", diffPackageQuantityEnable);
      map.put("diff_package_quantity_flag", diffPackageQuantityFlag);
      map.put("diff_package_quantity_value", diffPackageQuantityValue);
      map.put("diff_unit_price_with_tax_enable", diffUnitPriceWithTaxEnable);
      map.put("diff_unit_price_with_tax_flag", diffUnitPriceWithTaxFlag);
      map.put("diff_package_unit_price_with_tax_enable", diffPackageUnitPriceWithTaxEnable);
      map.put("diff_package_unit_price_with_tax_flag", diffPackageUnitPriceWithTaxFlag);
      map.put("diff_amount_with_tax_enable", diffAmountWithTaxEnable);
      map.put("diff_amount_with_tax_flag", diffAmountWithTaxFlag);
      map.put("diff_amount_with_tax_value", diffAmountWithTaxValue);
      map.put("diff_amount_without_tax_enable", diffAmountWithoutTaxEnable);
      map.put("diff_amount_without_tax_flag", diffAmountWithoutTaxFlag);
      map.put("diff_amount_without_tax_value", diffAmountWithoutTaxValue);
      map.put("miss_from_bill_flag", missFromBillFlag);
      map.put("miss_to_bill_flag", missToBillFlag);
      map.put("miss_goods_flag", missGoodsFlag);
      map.put("suit_flag", suitFlag);
      map.put("new_old_flag", newOldFlag);
      map.put("diff_enable_flag", diffEnableFlag);
      map.put("config_id", configId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("diff_type", diffType);

      return map;
  }

  public static ReconBatch fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReconBatch entity = new ReconBatch();

    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_scene")) {
      Object obj = map.get("recon_scene");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconScene((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_type")) {
      Object obj = map.get("recon_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_mode")) {
      Object obj = map.get("batch_mode");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBatchMode((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBatchMode(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBatchMode(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("recon_policy_name")) {
      Object obj = map.get("recon_policy_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconPolicyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_status")) {
      Object obj = map.get("recon_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lock_status")) {
      Object obj = map.get("lock_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLockStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lock_time")) {
      Object obj = map.get("lock_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLockTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLockTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLockTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLockTime(null);
      }
    }
    if(map.containsKey("unlock_time")) {
      Object obj = map.get("unlock_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUnlockTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUnlockTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnlockTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUnlockTime(null);
      }
    }
    if(map.containsKey("issue_settlement_id")) {
      Object obj = map.get("issue_settlement_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIssueSettlementId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIssueSettlementId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setIssueSettlementId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("issue_settlement_no")) {
      Object obj = map.get("issue_settlement_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssueSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_tag")) {
      Object obj = map.get("batch_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pass_flag")) {
      Object obj = map.get("pass_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPassFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reason")) {
      Object obj = map.get("reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_id")) {
      Object obj = map.get("settlement_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_sales_organization_code")) {
      Object obj = map.get("seller_sales_organization_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_sales_organization_name")) {
      Object obj = map.get("seller_sales_organization_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_sales_group_code")) {
      Object obj = map.get("seller_sales_group_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_sales_group_name")) {
      Object obj = map.get("seller_sales_group_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_name")) {
      Object obj = map.get("buyer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_no")) {
      Object obj = map.get("buyer_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_retailer_code")) {
      Object obj = map.get("buyer_retailer_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerRetailerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_retailer_name")) {
      Object obj = map.get("buyer_retailer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_tenant_id")) {
      Object obj = map.get("buyer_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBuyerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBuyerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchase_order_no")) {
      Object obj = map.get("purchase_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_quantity_from")) {
      Object obj = map.get("package_quantity_from");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageQuantityFrom((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageQuantityFrom(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageQuantityFrom(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageQuantityFrom(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageQuantityFrom(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("package_quantity_to")) {
      Object obj = map.get("package_quantity_to");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageQuantityTo((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageQuantityTo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageQuantityTo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageQuantityTo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageQuantityTo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity_from")) {
      Object obj = map.get("quantity_from");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantityFrom((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantityFrom(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantityFrom(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantityFrom(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantityFrom(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity_to")) {
      Object obj = map.get("quantity_to");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantityTo((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantityTo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantityTo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantityTo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantityTo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax_from")) {
      Object obj = map.get("amount_with_tax_from");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTaxFrom((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTaxFrom(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTaxFrom(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTaxFrom(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTaxFrom(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax_to")) {
      Object obj = map.get("amount_with_tax_to");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTaxTo((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTaxTo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTaxTo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTaxTo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTaxTo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax_from")) {
      Object obj = map.get("amount_without_tax_from");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTaxFrom((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTaxFrom(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTaxFrom(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTaxFrom(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTaxFrom(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax_to")) {
      Object obj = map.get("amount_without_tax_to");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTaxTo((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTaxTo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTaxTo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTaxTo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTaxTo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_name_from")) {
      Object obj = map.get("bill_type_name_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillTypeNameFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_name_to")) {
      Object obj = map.get("bill_type_name_to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillTypeNameTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_no_from")) {
      Object obj = map.get("bill_no_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillNoFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_no_to")) {
      Object obj = map.get("bill_no_to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillNoTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_date_from")) {
      Object obj = map.get("bill_date_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillDateFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_date_to")) {
      Object obj = map.get("bill_date_to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillDateTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_quantity_enable")) {
      Object obj = map.get("diff_quantity_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffQuantityEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_quantity_flag")) {
      Object obj = map.get("diff_quantity_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffQuantityFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_quantity_value")) {
      Object obj = map.get("diff_quantity_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiffQuantityValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiffQuantityValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiffQuantityValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiffQuantityValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiffQuantityValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("diff_package_quantity_enable")) {
      Object obj = map.get("diff_package_quantity_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffPackageQuantityEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_package_quantity_flag")) {
      Object obj = map.get("diff_package_quantity_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffPackageQuantityFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_package_quantity_value")) {
      Object obj = map.get("diff_package_quantity_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiffPackageQuantityValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiffPackageQuantityValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiffPackageQuantityValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiffPackageQuantityValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiffPackageQuantityValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("diff_unit_price_with_tax_enable")) {
      Object obj = map.get("diff_unit_price_with_tax_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffUnitPriceWithTaxEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_unit_price_with_tax_flag")) {
      Object obj = map.get("diff_unit_price_with_tax_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffUnitPriceWithTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_package_unit_price_with_tax_enable")) {
      Object obj = map.get("diff_package_unit_price_with_tax_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffPackageUnitPriceWithTaxEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_package_unit_price_with_tax_flag")) {
      Object obj = map.get("diff_package_unit_price_with_tax_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffPackageUnitPriceWithTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_with_tax_enable")) {
      Object obj = map.get("diff_amount_with_tax_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffAmountWithTaxEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_with_tax_flag")) {
      Object obj = map.get("diff_amount_with_tax_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffAmountWithTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_with_tax_value")) {
      Object obj = map.get("diff_amount_with_tax_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiffAmountWithTaxValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiffAmountWithTaxValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiffAmountWithTaxValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiffAmountWithTaxValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiffAmountWithTaxValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_without_tax_enable")) {
      Object obj = map.get("diff_amount_without_tax_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffAmountWithoutTaxEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_without_tax_flag")) {
      Object obj = map.get("diff_amount_without_tax_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffAmountWithoutTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_without_tax_value")) {
      Object obj = map.get("diff_amount_without_tax_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiffAmountWithoutTaxValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiffAmountWithoutTaxValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiffAmountWithoutTaxValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiffAmountWithoutTaxValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiffAmountWithoutTaxValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("miss_from_bill_flag")) {
      Object obj = map.get("miss_from_bill_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMissFromBillFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("miss_to_bill_flag")) {
      Object obj = map.get("miss_to_bill_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMissToBillFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("miss_goods_flag")) {
      Object obj = map.get("miss_goods_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMissGoodsFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("suit_flag")) {
      Object obj = map.get("suit_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSuitFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_old_flag")) {
      Object obj = map.get("new_old_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewOldFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_enable_flag")) {
      Object obj = map.get("diff_enable_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffEnableFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config_id")) {
      Object obj = map.get("config_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConfigId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConfigId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setConfigId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_type")) {
      Object obj = map.get("diff_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiffType((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_scene")) {
      Object obj = map.get("recon_scene");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReconScene((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_type")) {
      Object obj = map.get("recon_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReconType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_mode")) {
      Object obj = map.get("batch_mode");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBatchMode((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBatchMode(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBatchMode(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("recon_policy_name")) {
      Object obj = map.get("recon_policy_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReconPolicyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_status")) {
      Object obj = map.get("recon_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReconStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lock_status")) {
      Object obj = map.get("lock_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLockStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lock_time")) {
      Object obj = map.get("lock_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLockTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setLockTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLockTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setLockTime(null);
      }
    }
    if(map.containsKey("unlock_time")) {
      Object obj = map.get("unlock_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUnlockTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUnlockTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnlockTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUnlockTime(null);
      }
    }
    if(map.containsKey("issue_settlement_id")) {
      Object obj = map.get("issue_settlement_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setIssueSettlementId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIssueSettlementId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setIssueSettlementId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("issue_settlement_no")) {
      Object obj = map.get("issue_settlement_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIssueSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_tag")) {
      Object obj = map.get("batch_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBatchTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pass_flag")) {
      Object obj = map.get("pass_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPassFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reason")) {
      Object obj = map.get("reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_id")) {
      Object obj = map.get("settlement_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettlementId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_sales_organization_code")) {
      Object obj = map.get("seller_sales_organization_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_sales_organization_name")) {
      Object obj = map.get("seller_sales_organization_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_sales_group_code")) {
      Object obj = map.get("seller_sales_group_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_sales_group_name")) {
      Object obj = map.get("seller_sales_group_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_name")) {
      Object obj = map.get("buyer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_no")) {
      Object obj = map.get("buyer_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_retailer_code")) {
      Object obj = map.get("buyer_retailer_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerRetailerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_retailer_name")) {
      Object obj = map.get("buyer_retailer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_tenant_id")) {
      Object obj = map.get("buyer_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBuyerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBuyerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBuyerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchase_order_no")) {
      Object obj = map.get("purchase_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_quantity_from")) {
      Object obj = map.get("package_quantity_from");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageQuantityFrom((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageQuantityFrom(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageQuantityFrom(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageQuantityFrom(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageQuantityFrom(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("package_quantity_to")) {
      Object obj = map.get("package_quantity_to");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageQuantityTo((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageQuantityTo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageQuantityTo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageQuantityTo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageQuantityTo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity_from")) {
      Object obj = map.get("quantity_from");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuantityFrom((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuantityFrom(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuantityFrom(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuantityFrom(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuantityFrom(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity_to")) {
      Object obj = map.get("quantity_to");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuantityTo((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuantityTo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuantityTo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuantityTo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuantityTo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax_from")) {
      Object obj = map.get("amount_with_tax_from");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTaxFrom((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTaxFrom(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTaxFrom(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTaxFrom(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTaxFrom(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax_to")) {
      Object obj = map.get("amount_with_tax_to");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTaxTo((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTaxTo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTaxTo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTaxTo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTaxTo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax_from")) {
      Object obj = map.get("amount_without_tax_from");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTaxFrom((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTaxFrom(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTaxFrom(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTaxFrom(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTaxFrom(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax_to")) {
      Object obj = map.get("amount_without_tax_to");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTaxTo((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTaxTo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTaxTo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTaxTo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTaxTo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_name_from")) {
      Object obj = map.get("bill_type_name_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillTypeNameFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_name_to")) {
      Object obj = map.get("bill_type_name_to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillTypeNameTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_no_from")) {
      Object obj = map.get("bill_no_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillNoFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_no_to")) {
      Object obj = map.get("bill_no_to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillNoTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_date_from")) {
      Object obj = map.get("bill_date_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillDateFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_date_to")) {
      Object obj = map.get("bill_date_to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillDateTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_quantity_enable")) {
      Object obj = map.get("diff_quantity_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffQuantityEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_quantity_flag")) {
      Object obj = map.get("diff_quantity_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffQuantityFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_quantity_value")) {
      Object obj = map.get("diff_quantity_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiffQuantityValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiffQuantityValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiffQuantityValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiffQuantityValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiffQuantityValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("diff_package_quantity_enable")) {
      Object obj = map.get("diff_package_quantity_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffPackageQuantityEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_package_quantity_flag")) {
      Object obj = map.get("diff_package_quantity_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffPackageQuantityFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_package_quantity_value")) {
      Object obj = map.get("diff_package_quantity_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiffPackageQuantityValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiffPackageQuantityValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiffPackageQuantityValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiffPackageQuantityValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiffPackageQuantityValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("diff_unit_price_with_tax_enable")) {
      Object obj = map.get("diff_unit_price_with_tax_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffUnitPriceWithTaxEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_unit_price_with_tax_flag")) {
      Object obj = map.get("diff_unit_price_with_tax_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffUnitPriceWithTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_package_unit_price_with_tax_enable")) {
      Object obj = map.get("diff_package_unit_price_with_tax_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffPackageUnitPriceWithTaxEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_package_unit_price_with_tax_flag")) {
      Object obj = map.get("diff_package_unit_price_with_tax_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffPackageUnitPriceWithTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_with_tax_enable")) {
      Object obj = map.get("diff_amount_with_tax_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffAmountWithTaxEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_with_tax_flag")) {
      Object obj = map.get("diff_amount_with_tax_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffAmountWithTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_with_tax_value")) {
      Object obj = map.get("diff_amount_with_tax_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiffAmountWithTaxValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiffAmountWithTaxValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiffAmountWithTaxValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiffAmountWithTaxValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiffAmountWithTaxValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_without_tax_enable")) {
      Object obj = map.get("diff_amount_without_tax_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffAmountWithoutTaxEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_without_tax_flag")) {
      Object obj = map.get("diff_amount_without_tax_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffAmountWithoutTaxFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_amount_without_tax_value")) {
      Object obj = map.get("diff_amount_without_tax_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiffAmountWithoutTaxValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiffAmountWithoutTaxValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiffAmountWithoutTaxValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiffAmountWithoutTaxValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiffAmountWithoutTaxValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("miss_from_bill_flag")) {
      Object obj = map.get("miss_from_bill_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMissFromBillFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("miss_to_bill_flag")) {
      Object obj = map.get("miss_to_bill_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMissToBillFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("miss_goods_flag")) {
      Object obj = map.get("miss_goods_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMissGoodsFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("suit_flag")) {
      Object obj = map.get("suit_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSuitFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_old_flag")) {
      Object obj = map.get("new_old_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNewOldFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_enable_flag")) {
      Object obj = map.get("diff_enable_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffEnableFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config_id")) {
      Object obj = map.get("config_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setConfigId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setConfigId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setConfigId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diff_type")) {
      Object obj = map.get("diff_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiffType((String)obj);
        }
      } else{
      }
    }
  }
}
