package com.xforceplus.ultraman.app.gemini.metadata.validator;

import com.xforceplus.ultraman.app.gemini.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.gemini.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2025-02-18
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = null != OrgType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = null != CreationMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = null != OrgStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = null != ReadStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = null != CreateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = null != MessageType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = null != EnableStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = null != VariableType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = null != WorkflowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReconScene.class)) {
            isValid = null != ReconScene.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReconScene.class.getSimpleName());
            }
        }
        if(clazz.equals(ReconType.class)) {
            isValid = null != ReconType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReconType.class.getSimpleName());
            }
        }
        if(clazz.equals(ReconStatus.class)) {
            isValid = null != ReconStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReconStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatus.class)) {
            isValid = null != LockStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LockStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(YesNo.class)) {
            isValid = null != YesNo.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YesNo.class.getSimpleName());
            }
        }
        if(clazz.equals(PassFlag.class)) {
            isValid = null != PassFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PassFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(DiffEnableStatus.class)) {
            isValid = null != DiffEnableStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DiffEnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DiffFlag.class)) {
            isValid = null != DiffFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DiffFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(MissFlag.class)) {
            isValid = null != MissFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MissFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfirmFlag.class)) {
            isValid = null != ConfirmFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(DiffType.class)) {
            isValid = null != DiffType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DiffType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillSource.class)) {
            isValid = null != BillSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillSource.class.getSimpleName());
            }
        }
        if(clazz.equals(BillType.class)) {
            isValid = null != BillType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
