package com.xforceplus.ultraman.app.gemini.metadata.validator;

import com.xforceplus.ultraman.app.gemini.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.gemini.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2025-02-18
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreationMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReadStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MessageType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EnableStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VariableType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WorkflowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReconScene.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReconScene.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReconScene.class.getSimpleName());
            }
        }
        if(clazz.equals(ReconType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReconType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReconType.class.getSimpleName());
            }
        }
        if(clazz.equals(ReconStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReconStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReconStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LockStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LockStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(YesNo.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YesNo.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YesNo.class.getSimpleName());
            }
        }
        if(clazz.equals(PassFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PassFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PassFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(DiffEnableStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DiffEnableStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DiffEnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DiffFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DiffFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DiffFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(MissFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MissFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MissFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfirmFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConfirmFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(DiffType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DiffType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DiffType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillSource.class.getSimpleName());
            }
        }
        if(clazz.equals(BillType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
