package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * lock_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-19
 */
public enum LockStatus {

    UNLOCKED("unlocked", "未锁定"),
    LOCKING("locking", "锁定中"),
    LOCKED("locked", "已锁定");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    LockStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LockStatus fromCode(String code) {
        return Stream.of(LockStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
