package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recon_scene
 * </p>
 *
 * @author ultraman
 * @since 2025-02-19
 */
public enum ReconScene {

    _1("1", "收发货核对"),
    _2("2", "收发货对账"),
    _3("3", "结算对账");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReconScene(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReconScene fromCode(String code) {
        return Stream.of(ReconScene.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
