package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recon_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-19
 */
public enum ReconStatus {

    _0("0", "未对账"),
    _1("1", "对账中"),
    _2("2", "部分对账"),
    _3("3", "待确认"),
    _4("4", "已对账"),
    _5("5", "已失效"),
    __1("-1", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReconStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReconStatus fromCode(String code) {
        return Stream.of(ReconStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
