package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * workflow_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-19
 */
public enum WorkflowStatus {

    _0("0", "进行中"),
    _1("1", "完成"),
    __1("-1", "异常"),
    _2("2", "终止"),
    _3("3", "撤回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WorkflowStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WorkflowStatus fromCode(String code) {
        return Stream.of(WorkflowStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
