package com.xforceplus.ultraman.app.gemini.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * recon_bill_item_info
 * </p>
 *
 * @author ultraman
 * @since 2025-02-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReconBillItemInfo implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 对账单id
   */
  private Long billId;
  /**
   * 单据编号
   */
  private String billNo;
  /**
   * 单据来源
   */
  private String billSource;
  /**
   * 单据类型编码
   */
  private String billType;
  /**
   * 对账单明细id
   */
  private Long billItemId;
  /**
   * 明细编号
   */
  private String itemNo;
  /**
   * 明细名称
   */
  private String itemName;
  /**
   * 明细编码
   */
  private String itemCode;
  /**
   * 商品条码
   */
  private String barcode;
  /**
   * 批量包装规格
   */
  private String packageSpecifications;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 数量
   */
  private BigDecimal quantity;
  /**
   * 单位
   */
  private String unit;
  /**
   * 批量包装数量
   */
  private BigDecimal packageQuantity;
  /**
   * 批量包装单位
   */
  private String packageUnit;
  /**
   * 不含税单价
   */
  private BigDecimal unitPrice;
  /**
   * 含税单价
   */
  private BigDecimal unitPriceWithTax;
  /**
   * 税收分类编码
   */
  private String goodsTaxNo;
  /**
   * 税收分类编码版本
   */
  private String goodsTaxNoVersion;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 最小单位
   */
  private String stockKeepingUnit;
  /**
   * 最小单位数量
   */
  private BigDecimal skuQuantity;
  /**
   * 最小单位含税单价
   */
  private BigDecimal skuPriceWithTax;
  /**
   * 最小单位不含税单价
   */
  private BigDecimal skuPriceWithoutTax;
  /**
   * 组套标志
   */
  private String suitFlag;
  /**
   * 销方组套商品数组
   */
  private String suitInfo;
  /**
   * 新老品标志
   */
  private String newOldFlag;
  /**
   * 销方新老商品数组
   */
  private String newOldInfo;
  /**
   * 价内折扣含税总金额
   */
  private BigDecimal innerDiscountWithTax;
  /**
   * 价内折扣不含税总金额
   */
  private BigDecimal innerDiscountWithoutTax;
  /**
   * 价外折扣含税总金额
   */
  private BigDecimal outerDiscountWithTax;
  /**
   * 价外折扣不含税总金额
   */
  private BigDecimal outerDiscountWithoutTax;
  /**
   * 销售订单编号
   */
  private String salesOrderNo;
  /**
   * 采购订单编号
   */
  private String purchaseOrderNo;
  /**
   * 原采购订单编号
   */
  private String purchaseOrderNoOld;
  /**
   * 修改采购订单编号备注
   */
  private String purchaseOrderNoRemark;
  /**
   * 销售出库单编号
   */
  private String deliveryNo;
  /**
   * 对账配置id
   */
  private Long configId;
  /**
   * 批量包装不含税单价
   */
  private BigDecimal packageUnitPrice;
  /**
   * 批量包装含税单价
   */
  private BigDecimal packageUnitPriceWithTax;
  /**
   * 明细规格
   */
  private String specifications;
  /**
   * 原始字段列表
   */
  private String srcField;
  /**
   * 生成批次场景
   */
  private Long batchMode;
  /**
   * 对账标签
   */
  private String reconTag;
  /**
   * 对账状态
   */
  private String reconStatus;
  /**
   * 对账时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reconTime;
  /**
   * 对账通过标志
   */
  private String reconPassFlag;
  /**
   * 对账差异标志
   */
  private String reconDiffFlag;
  /**
   * 对账失败信息
   */
  private String reconError;
  /**
   * 是否关联到单据标志
   */
  private String matchBillFlag;
  /**
   * 是否是对账单据
   */
  private String fromBillFlag;
  /**
   * 是否虚拟
   */
  private String virtualFlag;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 对账场景
   */
  private String reconScene;

  /**
   * 对一关联关系 关联对象 reconBatch
   */
  private Long batchItemId;
  /**
   * 对一关联关系 关联对象 reconGroup
   */
  private Long groupItemId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("bill_id", billId);
      map.put("bill_no", billNo);
      map.put("bill_source", billSource);
      map.put("bill_type", billType);
      map.put("bill_item_id", billItemId);
      map.put("item_no", itemNo);
      map.put("item_name", itemName);
      map.put("item_code", itemCode);
      map.put("barcode", barcode);
      map.put("package_specifications", packageSpecifications);
      map.put("amount_with_tax", amountWithTax);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("quantity", quantity);
      map.put("unit", unit);
      map.put("package_quantity", packageQuantity);
      map.put("package_unit", packageUnit);
      map.put("unit_price", unitPrice);
      map.put("unit_price_with_tax", unitPriceWithTax);
      map.put("goods_tax_no", goodsTaxNo);
      map.put("goods_tax_no_version", goodsTaxNoVersion);
      map.put("tax_rate", taxRate);
      map.put("tax_amount", taxAmount);
      map.put("stock_keeping_unit", stockKeepingUnit);
      map.put("sku_quantity", skuQuantity);
      map.put("sku_price_with_tax", skuPriceWithTax);
      map.put("sku_price_without_tax", skuPriceWithoutTax);
      map.put("suit_flag", suitFlag);
      map.put("suit_info", suitInfo);
      map.put("new_old_flag", newOldFlag);
      map.put("new_old_info", newOldInfo);
      map.put("inner_discount_with_tax", innerDiscountWithTax);
      map.put("inner_discount_without_tax", innerDiscountWithoutTax);
      map.put("outer_discount_with_tax", outerDiscountWithTax);
      map.put("outer_discount_without_tax", outerDiscountWithoutTax);
      map.put("sales_order_no", salesOrderNo);
      map.put("purchase_order_no", purchaseOrderNo);
      map.put("purchase_order_no_old", purchaseOrderNoOld);
      map.put("purchase_order_no_remark", purchaseOrderNoRemark);
      map.put("delivery_no", deliveryNo);
      map.put("config_id", configId);
      map.put("package_unit_price", packageUnitPrice);
      map.put("package_unit_price_with_tax", packageUnitPriceWithTax);
      map.put("specifications", specifications);
      map.put("src_field", srcField);
      map.put("batch_mode", batchMode);
      map.put("recon_tag", reconTag);
      map.put("recon_status", reconStatus);
      map.put("recon_time", BocpGenUtils.toTimestamp(reconTime));
      map.put("recon_pass_flag", reconPassFlag);
      map.put("recon_diff_flag", reconDiffFlag);
      map.put("recon_error", reconError);
      map.put("match_bill_flag", matchBillFlag);
      map.put("from_bill_flag", fromBillFlag);
      map.put("virtual_flag", virtualFlag);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("recon_scene", reconScene);

      map.put("batchItem.id", batchItemId);
      map.put("groupItem.id", groupItemId);
      return map;
  }

  public static ReconBillItemInfo fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReconBillItemInfo entity = new ReconBillItemInfo();

    if(map.containsKey("bill_id")) {
      Object obj = map.get("bill_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_source")) {
      Object obj = map.get("bill_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type")) {
      Object obj = map.get("bill_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_item_id")) {
      Object obj = map.get("bill_item_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("item_no")) {
      Object obj = map.get("item_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_specifications")) {
      Object obj = map.get("package_specifications");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageSpecifications((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_quantity")) {
      Object obj = map.get("package_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("package_unit")) {
      Object obj = map.get("package_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit_price_with_tax")) {
      Object obj = map.get("unit_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no_version")) {
      Object obj = map.get("goods_tax_no_version");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNoVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stock_keeping_unit")) {
      Object obj = map.get("stock_keeping_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStockKeepingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sku_quantity")) {
      Object obj = map.get("sku_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSkuQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSkuQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSkuQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSkuQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSkuQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sku_price_with_tax")) {
      Object obj = map.get("sku_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSkuPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSkuPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSkuPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSkuPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSkuPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sku_price_without_tax")) {
      Object obj = map.get("sku_price_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSkuPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSkuPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSkuPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSkuPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSkuPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("suit_flag")) {
      Object obj = map.get("suit_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSuitFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("suit_info")) {
      Object obj = map.get("suit_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSuitInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_old_flag")) {
      Object obj = map.get("new_old_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewOldFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_old_info")) {
      Object obj = map.get("new_old_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewOldInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inner_discount_with_tax")) {
      Object obj = map.get("inner_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inner_discount_without_tax")) {
      Object obj = map.get("inner_discount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outer_discount_with_tax")) {
      Object obj = map.get("outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outer_discount_without_tax")) {
      Object obj = map.get("outer_discount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOuterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOuterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOuterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOuterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOuterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_order_no")) {
      Object obj = map.get("sales_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_order_no")) {
      Object obj = map.get("purchase_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_order_no_old")) {
      Object obj = map.get("purchase_order_no_old");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseOrderNoOld((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_order_no_remark")) {
      Object obj = map.get("purchase_order_no_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseOrderNoRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delivery_no")) {
      Object obj = map.get("delivery_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config_id")) {
      Object obj = map.get("config_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConfigId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConfigId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setConfigId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("package_unit_price")) {
      Object obj = map.get("package_unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("package_unit_price_with_tax")) {
      Object obj = map.get("package_unit_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("specifications")) {
      Object obj = map.get("specifications");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecifications((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("src_field")) {
      Object obj = map.get("src_field");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_mode")) {
      Object obj = map.get("batch_mode");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBatchMode((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBatchMode(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBatchMode(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("recon_tag")) {
      Object obj = map.get("recon_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_status")) {
      Object obj = map.get("recon_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_time")) {
      Object obj = map.get("recon_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReconTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReconTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReconTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReconTime(null);
      }
    }
    if(map.containsKey("recon_pass_flag")) {
      Object obj = map.get("recon_pass_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconPassFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_diff_flag")) {
      Object obj = map.get("recon_diff_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconDiffFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_error")) {
      Object obj = map.get("recon_error");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconError((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_bill_flag")) {
      Object obj = map.get("match_bill_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchBillFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("from_bill_flag")) {
      Object obj = map.get("from_bill_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFromBillFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtual_flag")) {
      Object obj = map.get("virtual_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVirtualFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_scene")) {
      Object obj = map.get("recon_scene");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconScene((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("batchItem.id")) {
       Object obj = map.get("batchItem.id");
       if(obj instanceof Long) {
         entity.setBatchItemId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setBatchItemId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("groupItem.id")) {
       Object obj = map.get("groupItem.id");
       if(obj instanceof Long) {
         entity.setGroupItemId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setGroupItemId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bill_id")) {
      Object obj = map.get("bill_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBillId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_source")) {
      Object obj = map.get("bill_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type")) {
      Object obj = map.get("bill_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_item_id")) {
      Object obj = map.get("bill_item_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBillItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBillItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("item_no")) {
      Object obj = map.get("item_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_specifications")) {
      Object obj = map.get("package_specifications");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackageSpecifications((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_quantity")) {
      Object obj = map.get("package_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("package_unit")) {
      Object obj = map.get("package_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit_price_with_tax")) {
      Object obj = map.get("unit_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no_version")) {
      Object obj = map.get("goods_tax_no_version");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsTaxNoVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stock_keeping_unit")) {
      Object obj = map.get("stock_keeping_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStockKeepingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sku_quantity")) {
      Object obj = map.get("sku_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSkuQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSkuQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSkuQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSkuQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSkuQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sku_price_with_tax")) {
      Object obj = map.get("sku_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSkuPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSkuPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSkuPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSkuPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSkuPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sku_price_without_tax")) {
      Object obj = map.get("sku_price_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSkuPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSkuPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSkuPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSkuPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSkuPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("suit_flag")) {
      Object obj = map.get("suit_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSuitFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("suit_info")) {
      Object obj = map.get("suit_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSuitInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_old_flag")) {
      Object obj = map.get("new_old_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNewOldFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_old_info")) {
      Object obj = map.get("new_old_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNewOldInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inner_discount_with_tax")) {
      Object obj = map.get("inner_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inner_discount_without_tax")) {
      Object obj = map.get("inner_discount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outer_discount_with_tax")) {
      Object obj = map.get("outer_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outer_discount_without_tax")) {
      Object obj = map.get("outer_discount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOuterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOuterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOuterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOuterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOuterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_order_no")) {
      Object obj = map.get("sales_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_order_no")) {
      Object obj = map.get("purchase_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_order_no_old")) {
      Object obj = map.get("purchase_order_no_old");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseOrderNoOld((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_order_no_remark")) {
      Object obj = map.get("purchase_order_no_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseOrderNoRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delivery_no")) {
      Object obj = map.get("delivery_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeliveryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config_id")) {
      Object obj = map.get("config_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setConfigId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setConfigId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setConfigId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("package_unit_price")) {
      Object obj = map.get("package_unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("package_unit_price_with_tax")) {
      Object obj = map.get("package_unit_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("specifications")) {
      Object obj = map.get("specifications");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecifications((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("src_field")) {
      Object obj = map.get("src_field");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSrcField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_mode")) {
      Object obj = map.get("batch_mode");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBatchMode((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBatchMode(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBatchMode(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("recon_tag")) {
      Object obj = map.get("recon_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReconTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_status")) {
      Object obj = map.get("recon_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReconStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_time")) {
      Object obj = map.get("recon_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReconTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReconTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReconTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReconTime(null);
      }
    }
    if(map.containsKey("recon_pass_flag")) {
      Object obj = map.get("recon_pass_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReconPassFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_diff_flag")) {
      Object obj = map.get("recon_diff_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReconDiffFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_error")) {
      Object obj = map.get("recon_error");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReconError((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_bill_flag")) {
      Object obj = map.get("match_bill_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMatchBillFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("from_bill_flag")) {
      Object obj = map.get("from_bill_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFromBillFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtual_flag")) {
      Object obj = map.get("virtual_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVirtualFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recon_scene")) {
      Object obj = map.get("recon_scene");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReconScene((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("batchItem.id")) {
    Object obj = map.get("batchItem.id");
    if(obj instanceof Long) {
        this.setBatchItemId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setBatchItemId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("groupItem.id")) {
    Object obj = map.get("groupItem.id");
    if(obj instanceof Long) {
        this.setGroupItemId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setGroupItemId(Long.parseLong((String)obj));
    }
  }
  }
}
