package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_type
 * </p>
 *
 * @author ultraman
 * @since 2025-02-14
 */
public enum BillType {

    GOODS_RECEIVE_NOTE("GOODS_RECEIVE_NOTE", "收货单"),
    RETURN_TO_VENDOR("RETURN_TO_VENDOR", "退货单"),
    BILLING("BILLING", "billing单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillType fromCode(String code) {
        return Stream.of(BillType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
