package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * confirm_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-02-14
 */
public enum ConfirmFlag {

    _0("0", "未确认"),
    _1("1", "已确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ConfirmFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConfirmFlag fromCode(String code) {
        return Stream.of(ConfirmFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
