package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * diff_type
 * </p>
 *
 * @author ultraman
 * @since 2025-02-14
 */
public enum DiffType {

    UNIT_PRICE_WITH_TAX("unit_price_with_tax", "含税单价差"),
    PACKAGE_UNIT_PRICE_WITH_TAX("package_unit_price_with_tax", "含税箱价差"),
    PACKAGE_QUANTITY("package_quantity", "箱装量差"),
    QUANTITY("quantity", "量差"),
    AMOUNT_WITH_TAX("amount_with_tax", "含税金额差异"),
    AMOUNT_WITHOUT_TAX("amount_without_tax", "不含税金额差异"),
    MISS_GOODS("miss_goods", "商品不匹配"),
    MISS_FROM("miss_from", "对账单无数据"),
    MISS_TO("miss_to", "被对账单无数据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DiffType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DiffType fromCode(String code) {
        return Stream.of(DiffType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
