package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * org_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-14
 */
public enum OrgStatus {

    _0("0", "未启用"),
    _1("1", "启用"),
    _2("2", "禁用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrgStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrgStatus fromCode(String code) {
        return Stream.of(OrgStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
