package com.xforceplus.ultraman.app.gemini.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yes_no
 * </p>
 *
 * @author ultraman
 * @since 2025-02-14
 */
public enum YesNo {

    YES("yes", "是"),
    NO("no", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    YesNo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YesNo fromCode(String code) {
        return Stream.of(YesNo.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
