package com.xforceplus.ultraman.app.gemini.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.gemini.entity.ReconBatch;
import com.xforceplus.ultraman.app.gemini.service.IReconBatchService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 对账批次前端控制器
 *
 * @author ultraman
 * @date 2025-02-19
 */
@RestController
public class ReconBatchController {

  @Autowired
  private IReconBatchService reconBatchServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconBatch 对账批次
   * @return
   */
  @GetMapping("/reconbatchs" )
  public XfR getReconBatchs(XfPage page, ReconBatch reconBatch) {
    return XfR.ok(reconBatchServiceImpl.page(page, Wrappers.query(reconBatch)));
  }

  /**
   * 通过id查询对账批次
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconbatchs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconBatchServiceImpl.getById(id));
  }

  /**
   * 新增对账批次
   * @param reconBatch 对账批次
   * @return XfR
   */
  @PostMapping("/reconbatchs")
  public XfR save(@RequestBody ReconBatch reconBatch) {
     return XfR.ok(reconBatchServiceImpl.save(reconBatch));
  }

  /**
   * 修改-传入修改后的全部数据对账批次
   * @param reconBatch 对账批次
   * @return XfR
   */
  @PutMapping("/reconbatchs/{id}")
  public XfR putUpdate(@RequestBody ReconBatch reconBatch,@PathVariable Long id) {
      reconBatch.setId(id);
      return XfR.ok(reconBatchServiceImpl.updateById(reconBatch));
  }

  /**
   * 修改-传入修改的数据对账批次
   * @param reconBatch 对账批次
   * @return XfR
   */
  @PatchMapping("/reconbatchs/{id}")
  public XfR patchUpdate(@RequestBody ReconBatch reconBatch,@PathVariable Long id) {
      ReconBatch upreconBatch = reconBatchServiceImpl.getById(id);
      if(upreconBatch != null){
        upreconBatch = ObjectCopyUtils.copyProperties(reconBatch,upreconBatch,true);
      }
      return XfR.ok(reconBatchServiceImpl.updateById(upreconBatch));
  }

  /**
   * 通过id删除对账批次
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconbatchs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconBatchServiceImpl.removeById(id));
  }

  @PostMapping("/reconbatchs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "recon_batch");
     params.put("request", condition);

     return XfR.ok(reconBatchServiceImpl.querys(params));
  }

}
