package com.xforceplus.ultraman.app.gemini.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.gemini.entity.ReconBillItemInfo;
import com.xforceplus.ultraman.app.gemini.service.IReconBillItemInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 对账单明细信息前端控制器
 *
 * @author ultraman
 * @date 2025-02-19
 */
@RestController
public class ReconBillItemInfoController {

  @Autowired
  private IReconBillItemInfoService reconBillItemInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconBillItemInfo 对账单明细信息
   * @return
   */
  @GetMapping("/reconbilliteminfos" )
  public XfR getReconBillItemInfos(XfPage page, ReconBillItemInfo reconBillItemInfo) {
    return XfR.ok(reconBillItemInfoServiceImpl.page(page, Wrappers.query(reconBillItemInfo)));
  }

  /**
   * 通过id查询对账单明细信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconbilliteminfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconBillItemInfoServiceImpl.getById(id));
  }

  /**
   * 新增对账单明细信息
   * @param reconBillItemInfo 对账单明细信息
   * @return XfR
   */
  @PostMapping("/reconbilliteminfos")
  public XfR save(@RequestBody ReconBillItemInfo reconBillItemInfo) {
     return XfR.ok(reconBillItemInfoServiceImpl.save(reconBillItemInfo));
  }

  /**
   * 修改-传入修改后的全部数据对账单明细信息
   * @param reconBillItemInfo 对账单明细信息
   * @return XfR
   */
  @PutMapping("/reconbilliteminfos/{id}")
  public XfR putUpdate(@RequestBody ReconBillItemInfo reconBillItemInfo,@PathVariable Long id) {
      reconBillItemInfo.setId(id);
      return XfR.ok(reconBillItemInfoServiceImpl.updateById(reconBillItemInfo));
  }

  /**
   * 修改-传入修改的数据对账单明细信息
   * @param reconBillItemInfo 对账单明细信息
   * @return XfR
   */
  @PatchMapping("/reconbilliteminfos/{id}")
  public XfR patchUpdate(@RequestBody ReconBillItemInfo reconBillItemInfo,@PathVariable Long id) {
      ReconBillItemInfo upreconBillItemInfo = reconBillItemInfoServiceImpl.getById(id);
      if(upreconBillItemInfo != null){
        upreconBillItemInfo = ObjectCopyUtils.copyProperties(reconBillItemInfo,upreconBillItemInfo,true);
      }
      return XfR.ok(reconBillItemInfoServiceImpl.updateById(upreconBillItemInfo));
  }

  /**
   * 通过id删除对账单明细信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconbilliteminfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconBillItemInfoServiceImpl.removeById(id));
  }

  @PostMapping("/reconbilliteminfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "recon_bill_item_info");
     params.put("request", condition);

     return XfR.ok(reconBillItemInfoServiceImpl.querys(params));
  }

}
