package com.xforceplus.ultraman.app.gemini.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.gemini.entity.ReconGroup;
import com.xforceplus.ultraman.app.gemini.service.IReconGroupService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 对账结果 - 商品前端控制器
 *
 * @author ultraman
 * @date 2025-03-04
 */
@RestController
public class ReconGroupController {

  @Autowired
  private IReconGroupService reconGroupServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconGroup 对账结果 - 商品
   * @return
   */
  @GetMapping("/recongroups" )
  public XfR getReconGroups(XfPage page, ReconGroup reconGroup) {
    return XfR.ok(reconGroupServiceImpl.page(page, Wrappers.query(reconGroup)));
  }

  /**
   * 通过id查询对账结果 - 商品
   * @param  id
   * @return XfR
   */
  @GetMapping("/recongroups/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconGroupServiceImpl.getById(id));
  }

  /**
   * 新增对账结果 - 商品
   * @param reconGroup 对账结果 - 商品
   * @return XfR
   */
  @PostMapping("/recongroups")
  public XfR save(@RequestBody ReconGroup reconGroup) {
     return XfR.ok(reconGroupServiceImpl.save(reconGroup));
  }

  /**
   * 修改-传入修改后的全部数据对账结果 - 商品
   * @param reconGroup 对账结果 - 商品
   * @return XfR
   */
  @PutMapping("/recongroups/{id}")
  public XfR putUpdate(@RequestBody ReconGroup reconGroup,@PathVariable Long id) {
      reconGroup.setId(id);
      return XfR.ok(reconGroupServiceImpl.updateById(reconGroup));
  }

  /**
   * 修改-传入修改的数据对账结果 - 商品
   * @param reconGroup 对账结果 - 商品
   * @return XfR
   */
  @PatchMapping("/recongroups/{id}")
  public XfR patchUpdate(@RequestBody ReconGroup reconGroup,@PathVariable Long id) {
      ReconGroup upreconGroup = reconGroupServiceImpl.getById(id);
      if(upreconGroup != null){
        upreconGroup = ObjectCopyUtils.copyProperties(reconGroup,upreconGroup,true);
      }
      return XfR.ok(reconGroupServiceImpl.updateById(upreconGroup));
  }

  /**
   * 通过id删除对账结果 - 商品
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/recongroups/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconGroupServiceImpl.removeById(id));
  }

  @PostMapping("/recongroups/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "recon_group");
     params.put("request", condition);

     return XfR.ok(reconGroupServiceImpl.querys(params));
  }

}
