package com.xforceplus.ultraman.app.gemini.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.gemini.entity.WriteOffResultItem;
import com.xforceplus.ultraman.app.gemini.service.IWriteOffResultItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 核销结果明细前端控制器
 *
 * @author ultraman
 * @date 2025-03-04
 */
@RestController
public class WriteOffResultItemController {

  @Autowired
  private IWriteOffResultItemService writeOffResultItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param writeOffResultItem 核销结果明细
   * @return
   */
  @GetMapping("/writeoffresultitems" )
  public XfR getWriteOffResultItems(XfPage page, WriteOffResultItem writeOffResultItem) {
    return XfR.ok(writeOffResultItemServiceImpl.page(page, Wrappers.query(writeOffResultItem)));
  }

  /**
   * 通过id查询核销结果明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/writeoffresultitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(writeOffResultItemServiceImpl.getById(id));
  }

  /**
   * 新增核销结果明细
   * @param writeOffResultItem 核销结果明细
   * @return XfR
   */
  @PostMapping("/writeoffresultitems")
  public XfR save(@RequestBody WriteOffResultItem writeOffResultItem) {
     return XfR.ok(writeOffResultItemServiceImpl.save(writeOffResultItem));
  }

  /**
   * 修改-传入修改后的全部数据核销结果明细
   * @param writeOffResultItem 核销结果明细
   * @return XfR
   */
  @PutMapping("/writeoffresultitems/{id}")
  public XfR putUpdate(@RequestBody WriteOffResultItem writeOffResultItem,@PathVariable Long id) {
      writeOffResultItem.setId(id);
      return XfR.ok(writeOffResultItemServiceImpl.updateById(writeOffResultItem));
  }

  /**
   * 修改-传入修改的数据核销结果明细
   * @param writeOffResultItem 核销结果明细
   * @return XfR
   */
  @PatchMapping("/writeoffresultitems/{id}")
  public XfR patchUpdate(@RequestBody WriteOffResultItem writeOffResultItem,@PathVariable Long id) {
      WriteOffResultItem upwriteOffResultItem = writeOffResultItemServiceImpl.getById(id);
      if(upwriteOffResultItem != null){
        upwriteOffResultItem = ObjectCopyUtils.copyProperties(writeOffResultItem,upwriteOffResultItem,true);
      }
      return XfR.ok(writeOffResultItemServiceImpl.updateById(upwriteOffResultItem));
  }

  /**
   * 通过id删除核销结果明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/writeoffresultitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(writeOffResultItemServiceImpl.removeById(id));
  }

  @PostMapping("/writeoffresultitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "write_off_result_item");
     params.put("request", condition);

     return XfR.ok(writeOffResultItemServiceImpl.querys(params));
  }

}
