package com.xforceplus.ultraman.app.generalvoucher.controller;


/**
 * 系统用户任务对象feign客户端
 *
 * @author ultraman
 * @date 2025-09-19
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.generalvoucher.entity.SysFlowTask;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "general-voucher")
public interface SysFlowTaskFeignApi {

  /**
   * 通过id查询系统用户任务对象
   * @param  id
   * @return R
   */
  @GetMapping("/sysFlowTask/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统用户任务对象
   * @param sysFlowTask 系统用户任务对象
   * @return R
   */
  @PostMapping("/sysFlowTask/add")
  public R save(@RequestBody SysFlowTask sysFlowTask);

  /**
   * 修改系统用户任务对象
   * @param sysFlowTask 系统用户任务对象
   * @return R
   */
  @PostMapping("/sysFlowTask/update")
  public R updateById(@RequestBody SysFlowTask sysFlowTask);

  /**
   * 通过id删除系统用户任务对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/sysFlowTask/del/{id}" )
  public R removeById(@PathVariable Long id);

}