package com.xforceplus.ultraman.app.generalvoucher.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class VoucherGenerator implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 批次ID
   */
  private String genId;

  /**
   * 批次名称
   */
  private String name;

  /**
   * 发放总量
   */
  private Long limitNum;

  /**
   * 单张券总次数
   */
  private Long perNum;

  /**
   * 有效期类型
   */
  private String validateDateType;

  /**
   * 开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;

  /**
   * 结束日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;

  /**
   * 有效天数
   */
  private Long relDay;

  /**
   * 券批次是否超期领取
   */
  private Boolean allowGenExpire;

  /**
   * 券批次状态
   */
  private String genStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否支持混用
   */
  private Boolean allowMixUse;

  /**
   * 券码批次描述
   */
  private String remark;

  /**
   * 券码批次版本
   */
  private String genVer;

  /**
   * 已生成券码量
   */
  private Long generatedNum;

  /**
   * 领取截至日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expireDate;


  /**
   * 对一关联关系 关联对象 activity
   */
    private Long atovId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("gen_id", genId);
      map.put("name", name);
      map.put("limit_num", limitNum);
      map.put("per_num", perNum);
      map.put("validate_date_type", validateDateType);
      map.put("start_date", BocpGenUtils.toTimestamp(startDate));
      map.put("end_date", BocpGenUtils.toTimestamp(endDate));
      map.put("rel_day", relDay);
      map.put("allow_gen_expire", allowGenExpire);
      map.put("gen_status", genStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("allow_mix_use", allowMixUse);
      map.put("remark", remark);
      map.put("gen_ver", genVer);
      map.put("generated_num", generatedNum);
      map.put("expire_date", BocpGenUtils.toTimestamp(expireDate));

       map.put("atov.id", atovId);
      return map;
  }

  public static VoucherGenerator fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    VoucherGenerator entity = new VoucherGenerator();
    if(map.containsKey("gen_id")) {
      Object obj = map.get("gen_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGenId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("limit_num")) {
      Object obj = map.get("limit_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLimitNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLimitNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLimitNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("per_num")) {
      Object obj = map.get("per_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPerNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPerNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPerNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("validate_date_type")) {
      Object obj = map.get("validate_date_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setValidateDateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("start_date")) {
      Object obj = map.get("start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("end_date")) {
      Object obj = map.get("end_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("rel_day")) {
      Object obj = map.get("rel_day");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRelDay((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRelDay(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRelDay(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("allow_gen_expire")) {
      Object obj = map.get("allow_gen_expire");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setAllowGenExpire((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAllowGenExpire(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("gen_status")) {
      Object obj = map.get("gen_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGenStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allow_mix_use")) {
      Object obj = map.get("allow_mix_use");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setAllowMixUse((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAllowMixUse(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gen_ver")) {
      Object obj = map.get("gen_ver");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGenVer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generated_num")) {
      Object obj = map.get("generated_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGeneratedNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGeneratedNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGeneratedNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("expire_date")) {
      Object obj = map.get("expire_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpireDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExpireDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpireDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpireDate(null);
      }
    }

    if(map.containsKey("atov.id")) {
        Object obj = map.get("atov.id");
      if(obj instanceof Long) {
        entity.setAtovId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setAtovId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("gen_id")) {
      Object obj = map.get("gen_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGenId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("limit_num")) {
      Object obj = map.get("limit_num");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLimitNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLimitNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLimitNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("per_num")) {
      Object obj = map.get("per_num");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPerNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPerNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPerNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("validate_date_type")) {
      Object obj = map.get("validate_date_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValidateDateType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("start_date")) {
      Object obj = map.get("start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setStartDate(null);
      }
    }
    if(map.containsKey("end_date")) {
      Object obj = map.get("end_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setEndDate(null);
      }
    }
    if(map.containsKey("rel_day")) {
      Object obj = map.get("rel_day");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRelDay((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRelDay(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRelDay(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("allow_gen_expire")) {
      Object obj = map.get("allow_gen_expire");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setAllowGenExpire((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAllowGenExpire(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("gen_status")) {
      Object obj = map.get("gen_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGenStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("allow_mix_use")) {
      Object obj = map.get("allow_mix_use");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setAllowMixUse((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAllowMixUse(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gen_ver")) {
      Object obj = map.get("gen_ver");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGenVer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("generated_num")) {
      Object obj = map.get("generated_num");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGeneratedNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGeneratedNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setGeneratedNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("expire_date")) {
      Object obj = map.get("expire_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpireDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExpireDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpireDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExpireDate(null);
      }
    }
      if(map.containsKey("atov.id")) {
        Object obj = map.get("atov.id");
        if(obj instanceof Long) {
          this.setAtovId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAtovId(Long.parseLong((String)obj));
        }
      }
  }
}
